/*********************************************************************/
/*     GENARRAY . C    :    2�  Analisis de la estabilidad de genes  */
/*********************************************************************/
/*                                                                   */
/*  1- Lee lista de genes y de medidas de fichero con formato CSV.   */
/*  2- Configuracion del fichero de entrada:                         */
/*     Nombre_gen   Valores_de_TR   Valores_de_M                     */
/*********************************************************************/
/*  3- Realizamos estadisticas sobre parametros para asegurar la     */
/*     mejor opcion para la convergencia del calculo de M2.          */
/*                                                                   */
/*  4- Utiliza 2 terminos en el desarrollo de la funcion M2.         */
/*                                                                   */
/*  5- Ajusta dinamicamente el numero de pasos entre valores de Mi   */
/*     para calcular el Ki correctamente.                            */
/*                                                                   */
/*  6- El numero de pasos es fijo para cada minuto = N_PASOS.        */
/*                                                                   */
/*  7- Genera dos ficheros de salida:                                */
/*     F1 --> con informaci�n sobre la ejecuci�n.                    */
/*     F2--> con los valores de "ki" obrtenidos para los genes.      */
/*                                                                   */
/*********************************************************************/
/*    Vicente Arnau Llombart, Andrei Stefan Alic. 18 - Julio - 2011   */
/*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define LINEA        300
#define LINEA_LONG  300     // largo maximo de linea de datos
#define CERO         48     // codigo ASCII del "0"
#define PALABRA      40     // letras para el nombre de las proteinas

#define PUNTO_COMA   59

#define NO_DATO      -32768
#define INFINITO   33554432.0


#define INCREMENTO_QQ  0.1
// #define Q_POS         +2.0
// #define Q_NEG         -2.0

#define EPSILON       0.001

//===>> Ahora este valor se calcula de forma dinamica:
#define N_PASOS     50    // numero de pasos entre dos tiempos
#define N_P         10    // para vector de estadisticas de numero de pasos

#define MAX_CALCUL   80    // numero de CALCULOS para M BISECCION

#define MAX_APROX   5000    // numero de CALCULOS MAXIMO para APROXIMACION

//---->>  META  CALCULOS:  para m�s de 200 elementos me da error???----------
// unsigned int   vector[MAX_CALCUL+4]; // estadisticas convergencia contador


unsigned int   *vector;

int     falla_bi=0, me_alejo=0, menor_EP=0;
//-------------------------------------------------------------------------


double fun_Q2(double, double, double, double, int, int, double, int);

/**
 * Check if a certain index of a column must be retained or skipped; This function considers that the array of nonvalid indeces are sorted ascendenting
 */
int isValidCol(int indexVal, int *nonValidIndeces, int numNonValidIndeces, int checkFlag) {
	if (checkFlag) {
		int i;
		for (i=0; i<numNonValidIndeces; i++) {
			if (indexVal == nonValidIndeces[i])
				return 0;
			else if (indexVal < nonValidIndeces[i])//if the values are higher than the current index value stop searching
				return 1;
		}
	}
	return 1;
}

/**
 * argv[1] = experiment path
 * argv[2] = old file name - input file
 * argv[3] = new file name - output file
 * argv[4] = success message
 * argv[5] = separator of data in the source file
 * argv[6] = num times
 * argv[7] = listTimes
 * argv[8] = number of genes
 * argv[9] = total num of times available
 * argv[10] = indeces of non valid columns (columns which won't be used in the exp)
 */

main( int argc, char *argv[])
{
 FILE    *fin,  *fout1,  *fout2;
 char    ficha[LINEA], ficha_out[LINEA];
// char    linea[LINEA_LONG];

 double  **M, **TR, *Kest, **Kint; //--> ahora:   Kint = K1  !!!
 double  TRini, TRfin, Mini, Mfin;
 char    **gen, sss[LINEA_LONG], s_aux[PALABRA];
 int     lon_sss;
 int     *tt, n_tiempos, t2, t1, totalNumTimes, *timesIndNotAvail, numTimesIndNotAvail;    //---> tt = tiempos en minutos
 int     NN, n;             //---> NN = numero_datos_por_tiempo
 int     i, j, k, con, aux1, inicio, salgo;
 double  valor_Q, kk1; //--------> nuevas variables para fun_Q()
 int     cc;

 int     n_p, vpasos[N_P], pasos;
 double  error_k, k_old;
 int index = 0;
 char delimiter;
 //check if the a certain column must be discarded or not
 int checkFlag = 1;

//---------------------------------------------------------------------

 /*printf ("\n==============================================================");
 printf ("\n=                 G E N A R R A Y                              =");
 printf ("\n================================================================");
 printf ("\n= V. Arnau; J. Moreno; J. E. Perez; A. S. Alic 23 - VI - 2011  =");
 printf ("\n================================================================");

//---------->> pregunto n�mero de tiempos tomados:
 printf("\n\n Numero de tiempos tomados : ");*/
 //scanf("%d", &n_tiempos);

 //strncpy(argv[6], argv[6], strlen(argv[6]-1));
 delimiter = argv[5][0];
 printf("delim: %c\n", delimiter);

 totalNumTimes = atoi(argv[9]);

n_tiempos = atoi(argv[6]);
 if (n_tiempos<=0) {
       printf("\n Numero de tiempos incorrecto. \n");
       exit(0);
       }
//printf("here\n");

//==================  Reservo MEMORIA  para tiempos =================

 tt = (int *) calloc (n_tiempos, sizeof(int));
 if (tt == NULL)  {
    printf("\n Memory allocation failed.\n");
    exit(EXIT_FAILURE);
    }
 //printf("here\n");

//================== Pido tiempos  ====================================
 /*for (i=0; i<n_tiempos; i++){
      printf(" Tiempo[%2d] = ", i+1);
      scanf("%d", &tt[i]);

      if (i>0) {
           if(tt[i]<=tt[i-1]){
              printf("\n Error en los valores del los tiempos.");
              exit(0);
              }
           }
      }*/
    char delims[] = "_";

    char *tok = strtok(argv[7], delims);
    //printf ("%s\n", tok);

    while (tok != NULL) {
    	tt[index++] = atoi(tok);
    	printf("%d ", tt[index-1]);
        tok = strtok(NULL, delims);
    }
    if (n_tiempos < totalNumTimes) {
		printf("%s\n", argv[10]);
		index = 0;
		tok = strtok(argv[10], delims);
		// allocate the number of non-valid columns and add their indeces
		numTimesIndNotAvail = totalNumTimes - n_tiempos;
		timesIndNotAvail = (int *) calloc(numTimesIndNotAvail, sizeof(int));
		while (tok != NULL) {
			timesIndNotAvail[index++] = atoi(tok);
				printf("%d ", timesIndNotAvail[index-1]);
				tok = strtok(NULL, delims);

			}
    } else //disable discarding in the column discarding function
    	checkFlag = 0;

//---------->> pregunto n�mero de datos del experimento (NN):
 //printf("\n\nNumero de genes del experimento? =  ");
 //scanf("%d", &NN);
 NN = atoi(argv[8]);
 if (NN<=0) {
      printf("\n Numero de GENES incorrecto. \n");
      exit(0);
      }
//printf("here %d\n", NN);

//===============  Reservo MEMORIA  para VECTOR de estadisticas ===========

 vector = (unsigned int *) malloc ((MAX_CALCUL+1) * sizeof(unsigned int));
 if (vector == NULL)  {
    printf("\n Memory allocation failed in VECTOR.\n");
    exit(EXIT_FAILURE);
    }

 for (i=0; i<=MAX_CALCUL ; i++) vector[i]=0; //--> inicializo vector de CONT

//==================  Reservo MEMORIA  para datos (M y TR):

 M =  (double **)malloc(NN * sizeof(double *));    // per a M
 if (M== NULL){
    printf("\n memory allocation failed.\n");
    exit(EXIT_FAILURE);
    }
 for (i=0; i<NN; i++){
    M[i] = (double *) malloc(n_tiempos * sizeof(double));
    if (M[i]== NULL){
        printf("\n memory allocation failed. \n");
        exit(EXIT_FAILURE);
        }
    }

 TR =  (double **)malloc(NN * sizeof(double *));    // per a TR
 if (TR== NULL){
    printf("\n memory allocation failed.\n");
    exit(EXIT_FAILURE);
    }
 for (i=0; i<NN; i++){
    TR[i] = (double *) malloc(n_tiempos * sizeof(double));
    if (TR[i]== NULL){
        printf("\n memory allocation failed. \n");
        exit(EXIT_FAILURE);
        }
   }
//==================  Inicializo valores de  M  y  TR:
  for (i=0; i<NN; i++){
       for (j=0; j<n_tiempos; j++){
           M[i][j] = 0.0;
           TR[i][j]= 0.0;
           }
       }
//============  Reservo MEMORIA  para datos K_estacionario y K_intervalos

 Kint =  (double **)malloc(NN * sizeof(double *)); //--> per a K_intervalos
 if (Kint== NULL){
    printf("\n memory allocation failed in Kint.\n");
    fflush(stdin); getchar();
    exit(EXIT_FAILURE);
    }
 for (i=0; i<NN; i++){
    Kint[i] = (double *) malloc((n_tiempos-1) * sizeof(double)); //--> ojo: uno menos
    if (Kint[i]== NULL){
        printf("\n memory allocation failed in Kint[%d]. \n", i);
        fflush(stdin); getchar();
        exit(EXIT_FAILURE);
        }
   }

 Kest = (double *) malloc(NN * sizeof(double)); //--> per a K_estacionario
 if (Kest== NULL){
     printf("\n memory allocation failed in Kest. \n");
     fflush(stdin); getchar();
     exit(EXIT_FAILURE);
     }

//==================  Reservo MEMORIA  para nombre de GENES:

 gen = (char **) malloc(NN * sizeof(char *));    // lista de proteinas.
   if (gen == NULL) {
      printf("\n memory allocation failed.\n");
      exit(EXIT_FAILURE);
      }

 for (i=0; i < NN; i++){
      gen[i] =  (char *) malloc(PALABRA*sizeof(char));
      if (gen[i]== NULL){
         printf("\n memory allocation failed in element gen[%d].\n", i);
         exit(EXIT_FAILURE);
         }
      }
//===============================================================

//---------->> Pregunto por el nombre del fichero de datos:

 fflush(stdin);

 /*do{
      printf("\nInput File ? = ");
      gets(ficha);
      }
 while ((fin=fopen(ficha,"r"))==NULL);*/
 	 //ficha = argv[2];
     char *fpath = (char *) malloc(sizeof(char) * (strlen(argv[1]) + strlen(argv[2]) + 1));
     strcpy(fpath, argv[1]);
     strcat(fpath, argv[2]);
     fin=fopen(fpath, "r");
     //printf("%s\n", fpath);
 if (fin == NULL) {
	printf("\n Error leer la ficha %s\n", argv[2]);
        exit(EXIT_FAILURE);
 }
 free(fpath);
 //printf("here\n");

// printf ("\n Input File : %s", ficha);

//exit(0);
//     }//-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


 //OPEN THE OUTPUT FILE HERE TO BE ABLE TO WRITE THE HEADER IN IT
 //=======================  FICHERO  DE  SALIDA  F2    =====================
  strcpy(ficha_out, argv[1]);
   strcat(ficha_out, argv[3]);
  /*strcpy(ficha_out, argv[4]);
  strcat(ficha_out, "F2_");
  strcat(ficha_out, argv[5]);  //------ FICHERO salida
  strcat(ficha_out, "_Genes=");  //-->> para la 2� aplicacion

  sprintf(s_aux, "%d", NN); strcat(ficha_out, s_aux);*/


 // sprintf(s_aux, "%d", N_PASOS);
 // strcat(ficha_out, "_Pasos="); strcat(ficha_out, s_aux);

  //strcat(ficha_out, "_k.txt");

  if ( (fout2=fopen(ficha_out,"w"))==NULL) {
        printf ("\n Error opening \"%s\" file_2.\n", ficha_out);
        exit(0);
        }





//======================= LEO DATOS =====================================
 printf ("\n\n==========================================================");
 printf ("\n Leyendo datos del fichero ... \n");

 // read header
 while (fgetc(fin) != '\n');
/* //char *headerChar = (char *)malloc(sizeof(char) * 100);
 char c;
 char buffer[LINEA_LONG];
 int indexNum = 0;
 int keepReading = 1;
 int *colsIndex = (int *) calloc(sizeof(int) * atoi(argv[6]));
 int recogTimes = 0;
 int time;
 while (keepReading && recogTimes < n_tiempos) {//(c = fgetc(fin)) != '\n'){
	 c = fgetc(fin);
	 if (c == delimiter || c == '\n') {
		 if (indexNum > 0) {
			 //printf("%d\n", atoi(buffer));
			 time = atoi(buffer);
			 for (int i=0;i<n_tiempos;i++) {
				 if (tt[i] == time)
					 colsIndex[recogTimes++] = tt[i];
			 }
			 memset(buffer, 0, LINEA_LONG);
			 indexNum = 0;
		 }
		 if (c == '\n')
			 keepReading = 0;
	 } else if (c >= '0' && c <= '9') {
		 buffer[indexNum++] = c;
	 }
 	 //fputc(headerChar, fout2);
//fscanf(fin, "%[^\n]", headerChar);
 }*/
	   //printf("%s\n",headerChar);
//Write new header
   fprintf(fout2, "Gene%cK(%.2f)", delimiter, (float)tt[0]);
   for (index=0;index<n_tiempos-1;index++)
	   fprintf(fout2, "%cK(%.2f)", delimiter, (tt[index]+tt[index+1])/2.0);
   fputc('\n', fout2);
 /*fscanf(fin, "%s\n", sss);
 printf("%s\n", sss);*/


 for (n=0; n<NN ; n++) {
     strcpy(gen[n], "");
     fscanf(fin, "%s", sss); //-----------> leo linea completa!!!!
     //printf("%s\n", sss);
     lon_sss= strlen(sss);

     // printf("\n%s   %5d\n", sss, lon_sss);  fflush(stdin); getchar();

     //---> Reconozco nombre del gen:
     if (sss[0]== delimiter) {
          strcpy(gen[n],"----");
          j=1;
          }
     else {
          j=0;
          do {
              s_aux[j]=sss[j];
              j++;
              }
          while (sss[j]!=delimiter);
          s_aux[j]='\0';  //--> fin de string
          strcpy(gen[n], s_aux);
          j++; //--------------> siguiente dato

          // aux1= strlen(gen[n]);
          }

     // printf("\n[gen-%2d] %6s : ", n+1, gen[n]);
     index = 0;
     //-------------> Reconozco valores de TR:
     for (k=0; k<totalNumTimes; k++) {
        // printf("[%d] ", k);
        strcpy(s_aux, "");
        if (sss[j]== delimiter){
            if (isValidCol(k, timesIndNotAvail, numTimesIndNotAvail, checkFlag))
            	TR[n][index++]= NO_DATO;
           j++;
           }
        else {
           con=0;
           do {
              s_aux[con]=sss[j];
              con++; j++;
              }
           while (sss[j]!=delimiter);
           s_aux[con]= '\0'; //--> fin de string
           if (isValidCol(k, timesIndNotAvail, numTimesIndNotAvail, checkFlag))
        	   TR[n][index++]= atof(s_aux);
           j++;//--------------> siguiente dato
           //  printf("TR[%d]= %5.3f :  ", k, TR[n][k]);
           }
        } //------> for(k=0 to n_tiempos)

     index = 0;
     //------------> Reconozco valores de M:
     for (k=0; k<totalNumTimes; k++) {
        // printf("[k=%d, j=%d] ", k, j);
        strcpy(s_aux, "");
        if ((sss[j]== delimiter) || (j==lon_sss)){
            if (isValidCol(k, timesIndNotAvail, numTimesIndNotAvail, checkFlag))
            	M[n][index++]= NO_DATO;
           j++;
           }
        else {
           con=0;
           do {
               // if(k==(n_tiempos-1))
               //   { printf(" {j=%d}", j);  fflush(stdin); getchar(); }

               s_aux[con]=sss[j];
               con++; j++;
               }
           while ((sss[j]!=delimiter) && (j!=lon_sss));
           s_aux[con]= '\0';//--> fin de string
           if (isValidCol(k, timesIndNotAvail, numTimesIndNotAvail, checkFlag))
        	   M[n][index++]= atof(s_aux);
           j++; //--------------> siguiente dato
           //  printf(" | M[%d]= %5.3f : ", k, M[n][k]);
          }
        }//------> for(k=0 to n_datos)

      } //================>> del for(n=0 to NN)


//printf ("\n Datos leidos: ");
// fflush(stdin); getchar();


//------->>  elimino genes con TR1=0  o  M1=0 :   ---------------------

 for (i=0; i<NN; i++){
     if (TR[i][0]== 0.0)  TR[i][0]= NO_DATO;
     if ( M[i][0]== 0.0)   M[i][0]= NO_DATO;
     }

//-----   Para ver genes por pantalla :    ------------------------------

/* for (i=0; i<NN; i++){
     printf("\n%9s", gen[i]); //-----------> veo GEN
     for (j=0; j<n_tiempos; j++)  //---------> veo valores de TR
          if ( TR[i][j]== NO_DATO)
              printf("\t   -----");
          else
              printf("\t%8.5f", TR[i][j]);
     for (j=0; j<n_tiempos; j++)  //---------> veo valores de M
          if ( M[i][j]== NO_DATO)
              printf("\t   -----");
          else
              printf("\t%8.5f", M[i][j]);
     }*/
// fflush(stdin); getchar();

//=======================  FICHERO  DE  SALIDA  F1    =====================
 strcpy(ficha_out, argv[1]);
 strcat(ficha_out, "F1_");
 strcat(ficha_out, argv[5]);  //------ FICHERO salida
 strcat(ficha_out, "_Genes=");  //-->> para la 2� aplicacion

 sprintf(s_aux, "%d", NN);  strcat(ficha_out, s_aux);
//printf("ficha out: %s\n", ficha_out);

// sprintf(s_aux, "%d", N_PASOS);
// strcat(ficha_out, "_Pasos="); strcat(ficha_out, s_aux);

 //strcat(ficha_out, "_dat.txt");

 if ( (fout1=fopen(ficha_out,"w"))==NULL) {
       printf ("\n Error opening \"%s\" file_1.\n", ficha_out);
       exit(0);
       }


//==========================================================================

 fprintf (fout1,  "=======================================================");
 fprintf (fout1,"\n=               G E N A R R A Y                       =");
 fprintf (fout1,"\n=======================================================");
 fprintf (fout1,"\n=  V. Arnau; J. Moreno; J. E. Perez;  18 - VII - 2011 =");
 fprintf (fout1,"\n=======================================================");
 fprintf (fout1,"\n Con desarrollos de segundo orden.\n");
 fprintf (fout1,"\n EPSILON = %9.6f", EPSILON);
 fprintf (fout1,"\n N_PASOS ===>> DINAMICO. Valor inicial = %d", N_PASOS);

 fprintf (fout1, "\n\n N_tiempos = %3d", n_tiempos);

 fprintf (fout1, "\n\n Tiempos introducidos: ");
 for (i=0; i<n_tiempos; i++){
      fprintf (fout1,"\n t%d : %3d ", i, tt[i] );
      }

 fprintf (fout1, "\n\n N_genes = %6d \n", NN);

 fprintf (fout1, "\n Input File : %s", argv[2]);


//==========================================================================
//========================================================================

 for (i=0; i<N_P ; i++) vpasos[i] = 0;
 pasos = 0;

//========================================================================
//=========  EMPIEZAN LOS CALCULOS :     =================================

//=======================  Calculo de K_estacionario = K1 ================

 for (i=0; i<NN ; i++) {
     if ((TR[i][0]!= NO_DATO) && (M[i][0]!= NO_DATO))
         if (M[i][0]!=0)
              Kest[i] = TR[i][0] / M[i][0];  //--> segun la hoja Excel!!
         else Kest[i] = INFINITO;
     else
         Kest[i] = NO_DATO;
     }

//=======================  Calculo de K_INTERVALOS  =====================

// printf ("\n\n Calculo los K_INTERVALOS \n (pulsa tecla) ... ");
// fflush(stdin); getchar();


 for (i=0; i<NN ; i++) {
   // printf ("\nGEN-%d : \t %8s ", i+1, gen[i]);

   if ((Kest[i]==NO_DATO) || (Kest[i]==INFINITO))
        for (j=0; j<(n_tiempos-1); j++)   Kint[i][j]= NO_DATO;  //--> LA MADRE QUE LO ...
   else {

      j=0; //------>> Inicializo primer tiempo!!!!
      // pasos=0;
      salgo = 0;
      do {
         if ((TR[i][j]!= NO_DATO) && (M[i][j]!= NO_DATO)) {
            TRini= TR[i][j]; Mini=M[i][j]; t1= tt[j];
            j++;
            salgo=1;
            }
         else { //--->>> ESTO SOBRA.
            Kint[i][j] = NO_DATO;
            j++;
            }
         }
      while ((j<(n_tiempos-1)) && (salgo==0));


      while (j<(n_tiempos)){
         if ((TR[i][j]!= NO_DATO) && (M[i][j]!= NO_DATO)) {
            TRfin= TR[i][j]; Mfin=M[i][j]; t2= tt[j];
            //---> la llamada a esta funci�n devuelve el valor de Ki , i=2..T
            //---> pero lo que calculo es el valor de Q:

            // Kint[i][j-1]= fun_K(TRini, TRfin, Mini, Mfin, t1, t2); //==>> fun_K_resto

            if (j==1){

                 n_p = N_PASOS; //--> numero de pasos inicial
                 pasos=0;
                 // printf("\n----------------------------------");
                 kk1 = Kest[i];

                 valor_Q= fun_Q2(TRini, TRfin, Mini, Mfin, t1, t2, kk1, n_p); //==>> fun_K_resto
                 Kint[i][j-1]= Kest[i] + valor_Q * (t2 - t1); //--> primer valor de K_est

                 k_old = Kint[i][j-1];
                 pasos++;

                 // printf("\n k_int(j=1) = %11.8f ", k_old);
                 // printf("\n------");

                 do {
                     n_p = n_p * 2; //--> duplico el numero de pasos cada vez.

                     valor_Q= fun_Q2(TRini, TRfin, Mini, Mfin, t1, t2, kk1, n_p); //==>> fun_K_resto
                     Kint[i][j-1]= Kest[i] + valor_Q * (t2 - t1); //--> primer valor de K_est

                     error_k = Kint[i][j-1] - k_old;
                     k_old   = Kint[i][j-1];
                     pasos++;
                     if (error_k < 0) error_k = -error_k;

                     // printf("\n k_int   = %11.8f ", Kint[i][j-1]);
                     // printf("\t Error_K = %11.8f ", error_k);
                     // printf("\n------");

                     }
                 while(error_k > EPSILON);

                 if (pasos< N_P ) vpasos[pasos]++;
                 else vpasos[N_P-1]++;

                 }
            else {
                 cc=j-2; kk1= NO_DATO;
                 do{
                    if (Kint[i][cc]!= NO_DATO)
                       kk1 = Kint[i][cc];
                    else {
                         cc--;
                         if (cc==-1)  kk1 = Kest[i];
                         }
                    }
                 while(kk1==NO_DATO);

                 n_p = N_PASOS; //--> numero de pasos inicial
                 pasos=0;
                 // printf("\n----------------------------------");

                 valor_Q= fun_Q2(TRini, TRfin, Mini, Mfin, t1, t2, kk1, n_p); //==>> fun_K_resto
                 Kint[i][j-1]=  kk1 + valor_Q * (t2 - t1); //--> siguientes K_est

                 k_old = Kint[i][j-1];
                 pasos++;

                 // printf("\n k_int   = %11.8f ", k_old);
                 // printf("\n------");

                 do {
                     n_p = n_p * 2; //--> duplico el numero de pasos cada vez.
                     valor_Q= fun_Q2(TRini, TRfin, Mini, Mfin, t1, t2, kk1, n_p); //==>> fun_K_resto
                     Kint[i][j-1]= kk1 + valor_Q * (t2 - t1); //--> primer valor de K_est

                     error_k = Kint[i][j-1] - k_old;
                     k_old   = Kint[i][j-1];
                     pasos++;
                     if (error_k < 0) error_k = -error_k;

                     // printf("\n k_int   = %11.8f ", Kint[i][j-1]);
                     // printf("\t Error_K = %11.8f ", error_k);
                     // printf("\n------");

                     }
                 while(error_k > EPSILON);
                 if (pasos< N_P ) vpasos[pasos]++;
                 else vpasos[N_P-1]++;


                 }
            TRini= TRfin; Mini= Mfin; t1=t2;
            j++;
            }
          else {
            Kint[i][j-1]= NO_DATO;
            j++;
            }
          }//----->> del while
      }//--->> del IF de NO_DATO el Kest

      //  printf ("\t Fin:[Gen-%d]", i+1);
      // printf("\n-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-");
      // printf("+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+");

      // fflush(stdin); getchar();   //--> PARA PARA CADA GEN


    }//--------->>  del for de NN datos


// for (i=0; i<NN ; i++) {
//      printf ("\n%5d \t %6s ", i+1, gen[i]);
//      if (Kest[i]!= NO_DATO){
//          if (Kest[i]!= INFINITO)
//              printf ("\t %9.6f", Kest[i]);
//          else printf ("\t --INF-- ");
//          }
//      else
//          printf("\t ------- ");
//
//      for (j=0; j<(n_tiempos-1) ; j++) {
//           if (Kint[i][j] != NO_DATO)
//               printf ("\t %7.4f ", Kint[i][j]);
//           else
//               printf ("\t ------- ");
//           }
//    }//--------->>  del for de NN datos

// fflush(stdin); getchar();
// printf ("\n\n Pulsa techa y a fichero !!! \n");
// fflush(stdin); getchar();


//========================================================================
//=========    Resultados a fichero      =================================

// fprintf (fout, "\n    N\t    Gen \t  Kest  ");   //--> falta anyadir  Ki !!
// for (j=0; j<(n_tiempos-1) ; j++) {
//      sprintf(s_aux, "%d", j+2);
//      strcpy(ficha_out, "K"); strcat(ficha_out, s_aux);
//      fprintf (fout, "\t      %s ", ficha_out);
//     }
// fprintf (fout, "\n-------------------------------------------------------");
 char *tempData;
 for (i=0; i<NN ; i++) {
      // printf ("\n%5d \t %6s ", i+1, gen[i]);
      //fprintf (fout2, "%5d; %6s ", i+1, gen[i]);//"%5d\t %6s ", i+1, gen[i]);
	 //strcat(gen[i], separator);
      //fprintf (fout2, "%6s", gen[i]);//"%5d\t %6s ", i+1, gen[i]);
      if (Kest[i]!= NO_DATO){
          if (Kest[i]!= INFINITO) {
        	  fprintf (fout2, "%s%c%8.6f", gen[i], delimiter, Kest[i]);
              //fprintf (fout2, "%c%8.6f", delimiter, Kest[i]);//"\t %9.6f", Kest[i]);
          } else {
        	  continue;
        	  //fprintf (fout2, "%c--INF--", delimiter);//"\t --INF-- ");
          }
      }
      else
    	  fprintf (fout2, "%s%c", gen[i], delimiter);
          //fprintf (fout2, "%c", delimiter);//"\t   -------");

      //--------->> Imprimo los valores de K_estacionario:
      for (j=0; j<(n_tiempos-1) ; j++) {
          if (Kint[i][j] != NO_DATO){
              fprintf (fout2, "%c%8.6f", delimiter, Kint[i][j]);//"\t %9.6f", Kint[i][j]);
          } else {
              fprintf (fout2, "%c", delimiter);
              //fprintf (fout2, ";");//"\t   -------");
          }
      }
      fprintf (fout2, "\n"); //---->> fin de gen y de linea.
}

// fprintf(fout,"\n=======================================================");

//========================================================================

 fprintf(fout1, "\n=======================================================");
 fprintf(fout1, "\n Convergencia    n_casos ");
 fprintf(fout1, "\n-------------------------------------------------------");

 for (i=1; i<=MAX_CALCUL ; i++) fprintf(fout1, "\n %3d     \t  %6d", i, vector[i]);
 fprintf(fout1, "\n=======================================================");
 fprintf(fout1, "\n== Salidas de APROXIMACION INICIAL por alejamiento= %3d \n",
          me_alejo);
 fprintf(fout1, "\n== Salidas de APROXIMACION INICIAL por menor EPSILON= %3d \n",
          menor_EP);
 fprintf(fout1, "\n== Fallo en METODO de la BISECCION  = %3d", falla_bi);
 if (falla_bi>0)  fprintf(fout1, "\n== Prueba con un valor de PASOS mayor.");
 fprintf(fout1, "\n=======================================================");

 fprintf(fout1, "\n=======================================================");
 fprintf(fout1, "\n N_pasos/minuto \t Vector_pasos[N] ");
 fprintf(fout1, "\n-------------------------------------------------------");
 n_p= N_PASOS;
 for (i=1; i<N_P ; i++){
      fprintf(fout1, "\n %6d  \t %8d", n_p, vpasos[i]);
      n_p = n_p*2;
      }
 fprintf(fout1, "\n=======================================================");

//========================================================================

// fflush(stdin); getchar();
// printf ("\n\n Cierro ficheros ... \n");

 fclose(fin); fclose(fout1);fclose(fout2);


// fflush(stdin); getchar();
// printf ("\n\n Voy a cerrar punteros ... \n");
// fflush(stdin); getchar();

 for (n=0; n<NN ; n++) {
      free(M[n]); free(TR[n]); free(gen[n]); free(Kint[n]);
      }

// printf ("\n\n Voy a cerrar hijos ... \n");
// fflush(stdin); getchar();
 free(M); free(TR); free(Kest); free(Kint); free(gen);

//  printf ("\n\n Voy a cerrar VECTOR ... \n");
// fflush(stdin); getchar();
 free(vector);
 if (n_tiempos < totalNumTimes)
	 free(timesIndNotAvail);

 free(tt);
 //printf ("\n\n Fin de programa !!! \n");
 //printf ("\t\t  . . . pulsa una tecla.\n");

 fflush(stdin); //getchar();
 printf (argv[4]);
 return(NN);
}
//================   FIN DE PROGRAMA  =====================================
//=========================================================================









//=========================================================================
//============   FUNCION  Ki  intermedios : con i={2, ... , Tiempos} ======

double fun_Q2(double TR1, double TR2, double M1, double M2, int tt1, int tt2, double kk1, int nn_pp)
{
 double   p, faux;
 double   mm2, incre1_M, incre2_M, incre_t, acumula_M;
 double   qq, dif, mdif, mdif_antes;

 double   incre_qq = INCREMENTO_QQ;  //--> definida arriba como  0.1
 double   tiempo;
 int      ii, cont, cont2, salgo;
 int      me_paso;



// if (M2==0) M2=0.0001;

// printf("\n TR1=%9.6f  TR2=%9.6f  M1=%9.6f  M2=%9.6f (%d-%d) k_ant=%9.6f\n",
//         TR1, TR2, M1, M2, tt2, tt1, kk1);

 // if (M2==0) M2=0.0001;

// printf("\n Pasos/minuto = %d ", nn_pp);

 p = (TR2- TR1)/(tt2-tt1);

// if (M2==0.0) M2 = EPSILON; //--->>  PRUEBA QUE NO SIRVE!!!


//------->>>> Calculo variable  m2'  --------------------------------------

 mm2  = p - (TR1* kk1) + (M1 * kk1 * kk1);
 faux = kk1 * (tt2 - tt1);
 mm2  = mm2 * (exp(-faux)) - p + TR2 * kk1;

 if (kk1!=0)
      mm2  = mm2 / (kk1 * kk1); //-->>  ES PROBLEMATICO :  KK1 <> 0
 else {
      kk1= EPSILON;
      mm2  = mm2 / (kk1 * kk1);
      }

 dif  = mm2 - M2;

// if (dif>0) {qq = Q_POS;}
// else       {qq = Q_NEG;}

 qq = 0; //--->> Ahora partimos siempre de 0 y subimos o bajamos

 incre_t = (double) nn_pp; incre_t=1.0/incre_t;

 nn_pp = nn_pp* (tt2-tt1); //----------->>  NUMERO DE PASOS DINAMICO

 me_paso=0;
 cont = 0;
 salgo= 0;
 mdif = 0.0;
 mdif_antes = INFINITO;

 if (dif>0){ //-->> voy hacia ARRIBA  en valores de M2

    // printf("\n Estoy ARRIBA. QQ= %9.6f \n", qq);

    do{
       acumula_M = M1;

       incre1_M   = 0.0; //--->> inicializo
       incre2_M   = 0.0; //--->> inicializo

       // printf("\n [q=%11.8f]  ", qq);

       for (ii = 0; ii<nn_pp; ii++){
           tiempo    = incre_t * ii;
           //  acumula_M = acumula_M + incre_M;
           // incre_M = ((TR1 + (p * tiempo)) - ((kk1 + (qq * tiempo)) * acumula_M)) * incre_t;

           incre1_M = ((TR1 + (p * tiempo)) - ((kk1 + (qq * tiempo)) * acumula_M));

           incre2_M = p - (qq*acumula_M) - (kk1+(qq*tiempo)) * incre1_M;

           acumula_M = acumula_M + (incre1_M * incre_t) + (incre2_M * ((incre_t *incre_t)/2));

           // printf("\n [q=%9.6f]--[acu_M=%9.6f]--[incre_M=%9.6f]--(%3d) ",
           //          qq, acumula_M, incre_M, cont);
           // fflush(stdin); getchar();
           }

        dif = acumula_M - M2;
        dif = dif/(tt2 - tt1); //--->  error en funci�n de Q y no de K

        if (dif>0) mdif= +dif;
        else       mdif= -dif;

        if (mdif<EPSILON) salgo=2; //---> ya lo tengo!!!
        else {
            if (dif<0) {
                salgo=1;
                incre_qq= incre_qq/2;
                qq = qq - incre_qq; //---> me he pasado, voy hacia abajo!!
                }
            else {
                if (mdif> mdif_antes){
                    salgo = 1;
                    incre_qq= incre_qq/2;
                    qq = qq - incre_qq; //---> me he pasado, voy hacia abajo!!
                    // printf("\n [q=%11.8f] al salir \n", qq);
                    me_alejo++;
                    }
                 else  qq = qq + incre_qq; //--> sigo hacia arriba!!
                 }
            }

        cont++;

        mdif_antes = mdif; //--->> sin esto no va.


        // printf(" [acu_M=%15.8f]  [inc1_M=%12.8f] [inc2_M=%12.8f] [dif=%9.6f] (%3d) ",
        //       acumula_M, incre1_M, incre2_M, dif, cont);

        // fflush(stdin); getchar();

        }
   while ((salgo==0) && (cont<MAX_APROX));
   }//--->> del if(dif>0)

 else {//---->> voy hacia ABAJO, a buscar M2

    // printf("\n Estoy ABAJO. QQ= %9.6f \n", qq);
    do{
       acumula_M = M1;
       incre1_M   = 0.0; //--->> inicializo
       incre2_M   = 0.0; //--->> inicializo

       // printf("\n [q=%11.8f]  ", qq);

       for (ii = 0; ii<nn_pp; ii++){
           tiempo    = incre_t * ii;
           //  acumula_M = acumula_M + incre_M;

           incre1_M = ((TR1 + (p * tiempo)) - ((kk1 + (qq * tiempo)) * acumula_M));
           incre2_M = p - (qq*acumula_M) - (kk1+(qq*tiempo)) * incre1_M;

           acumula_M = acumula_M + (incre1_M * incre_t) + (incre2_M * ((incre_t *incre_t)/2));

           // printf("\n [q=%9.6f]--[acu_M=%9.6f]--[incre_M=%9.6f]--(%3d) ",
           //          qq, acumula_M, incre_M, cont);
           // fflush(stdin); getchar();
           }

        dif = acumula_M - M2;
        dif = dif/(tt2 - tt1); //--->  error en funci�n de Q y no de K


        if (dif>0) mdif= +dif;
        else       mdif= -dif;


        if (mdif<EPSILON) salgo=2; //---> ya lo tengo!!!
        else {
            if (dif>0) {
                salgo=1;
                incre_qq= incre_qq/2;
                qq = qq + incre_qq; //---> me he pasado, voy hacia arriba!!
                }
            else {
                if (mdif> mdif_antes){
                    salgo = 1;
                    incre_qq= incre_qq/2;
                    qq = qq + incre_qq; //---> me he pasado, voy hacia abajo!!
                    // printf("\n [q=%11.8f] al salir \n", qq);
                    me_alejo++;
                    }
                 else  qq = qq - incre_qq; //--> sigo hacia arriba!!
                 }
            }


        mdif_antes = mdif; //--->> sin esto no va.

        cont++;

        // printf(" [acu_M=%15.8f]  [inc1_M=%12.8f] [inc2_M=%12.8f] [dif=%9.6f] (%3d) ",
        //       acumula_M, incre1_M, incre2_M, dif, cont);

        // fflush(stdin); getchar();
        }
    while ((salgo==0) && (cont<MAX_APROX));
   }//-->> del else

//=====>> Ahora empiezo a saltar buscado la soluci�n: METODO DE LA BISECCION

 if (mdif< EPSILON) {
      // printf("\n ----->> salgo por acercarme a EPSILON!!");
      menor_EP++;
      }

 if (cont==MAX_APROX) { //--->> esto creo que no se da nunca!!
      printf("\n ----->> ERROR!!  . Contador = %d", cont);
      printf(" [acu_M=%15.8f]  [inc1_M=%12.8f] [inc2_M=%12.8f] [dif=%9.6f] (%3d) ",
               acumula_M, incre1_M, incre2_M, dif, cont);
      // fflush(stdin); getchar();
      }



// printf("\n");  //--->> separo ambos calculos

 cont2= 0; //---->> para el metodo de la BISECCI�N.

 if (salgo!=2) { //---->> no es necesario buscar mas !!!!!
  do{
    acumula_M = M1;

    incre1_M   = 0.0; //--->> inicializo
    incre2_M   = 0.0; //--->> inicializo

    // printf("\n [q=%11.8f]  ", qq);

    for (ii = 0; ii<nn_pp; ii++){
        tiempo    = incre_t * ii;
        //  acumula_M = acumula_M + incre_M;

        incre1_M = ((TR1 + (p * tiempo)) - ((kk1 + (qq * tiempo)) * acumula_M));
        incre2_M = p - (qq*acumula_M) - (kk1+(qq*tiempo)) * incre1_M;

        acumula_M = acumula_M + (incre1_M * incre_t) + (incre2_M * ((incre_t *incre_t)/2));

        //printf("\n [q=%9.6f]--[acu_M=%9.6f]--[incre_M=%9.6f]--(%3d) ",
        //         qq, acumula_M, incre_M, cont);
        // fflush(stdin); getchar();
        }

   dif = acumula_M - M2;


   if (dif > 0){//---> vuelvo a estar arriba:
           incre_qq = (incre_qq/2);
           qq = qq + incre_qq; //--> para subir, me he padado.
           }
    else  {//---> vuelvo a estar abajo:
           incre_qq = (incre_qq/2);
           qq = qq - incre_qq; //--> para subir.
           }

    cont++;
    cont2++;

    dif = dif/(tt2 - tt1); //--->  error en funci�n de Q y no de K

    // printf(" [acu_M=%15.8f]  [inc1_M=%12.8f] [inc2_M=%12.8f] [dif=%9.6f] (%3d) ",
    //           acumula_M, incre1_M, incre2_M, dif, cont);
    // fflush(stdin); getchar();

    if (dif<0) dif = -dif;
   }
  while ((dif>EPSILON) && (cont2<MAX_CALCUL));
 }//--->> del if(salgo==2)


// printf("\n Val_Q = %11.8f   (%3d ite)    Acu_M=%12.8f <--> M2=%11.8f",
//         qq, cont, acumula_M, M2);

//---->>>>  FALLA el metodo de la BISECCION:
 if (cont2==MAX_CALCUL){
      printf("\n ----->> Falla Metodo de la BISECCION!!\n");
      falla_bi++;
      }


 if ((cont < MAX_CALCUL) && (cont>0))
           vector[cont]++; //---->> estadisticas sobre numero de pasos


//-----------------------------------------------------------------------

// printf("\n- - - - - - - - - - - - - - - - - - - - - -");
// printf(" - - - - - - - - - - - - - - - ");
 // fflush(stdin); getchar();


 return(qq);
}
//*************************************************************************


