/*********************************************************************/
/*      STABILOGEN . C    :    Analisis de la estabilidad de genes   */
/*********************************************************************/
/*                                                                   */
/*  1- Lee lista de genes y de medidas de fichero con formato CSV.   */
/*  2- Configuracion del fichero de entrada:                         */
/*     Nombre_gen   Valores_de_TR   Valores_de_M                     */
/*                                                                   */
/*********************************************************************/
/*    Vicente Arnau Llombart, Andrei Stefan Alic.    19 - IV - 2011  */
/*********************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define LINEA       300
#define LINEA_LONG  144
#define CERO         48     // codigo ASCII del "0"
#define PALABRA      40     // letras para el nombre de las proteinas

//#define PUNTO_COMA   59

#define NO_DATO      -32768
#define INFINITO   33554432.0

#define EPSILON           0.000001

double fun_K_intervalo(double, double, double, double, int, int);

/**
 * Check if a certain index of a column must be retained or skipped; This function considers that the array of nonvalid indeces are sorted ascendenting
 */
int isValidCol(int indexVal, int *nonValidIndeces, int numNonValidIndeces, int checkFlag) {
	if (checkFlag) {
		int i;
		for (i=0; i<numNonValidIndeces; i++) {
			if (indexVal == nonValidIndeces[i])
				return 0;
			else if (indexVal < nonValidIndeces[i])//if the values are higher than the current index value stop searching
				return 1;
		}
	}
	return 1;
}

/**
 * argv[1] = experiment path
 * argv[2] = old file name - input file
 * argv[3] = new file name - output file
 * argv[4] = success message
 * argv[5] = separator of data in the source file
 * argv[6] = num times
 * argv[7] = listTimes
 * argv[8] = number of genes
 * argv[9] = total num of times available
 * argv[10] = indeces of non valid columns (columns which won't be used in the exp)
 */
int main( int argc, char *argv[])
{
 FILE    *fin,  *fout;
 char    ficha[LINEA], ficha_out[LINEA];
// char    linea[LINEA_LONG];

 double  **M, **TR, *Kest, **Kint;
 double  TRini, TRfin, Mini, Mfin;
 char    **gen, sss[LINEA_LONG], s_aux[PALABRA];
 int     lon_sss;
 int     *tt, n_tiempos, t2, t1, totalNumTimes, *timesIndNotAvail, numTimesIndNotAvail;    //---> tt = tiempos en minutos
 int     NN, n;             //---> NN = numero_datos_por_tiempo
 int     i, j, k, con, aux1, inicio, salgo, index;
 char delimiter;
 //check if the a certain column must be discarded or not
 int checkFlag = 1;



 /*printf ("\n===============================================================");
 printf ("\n=            S T A B I L O G E N                                =");
 printf ("\n=================================================================");
 printf ("\n=  V. Arnau; J. Moreno; J. E. Perez; A. S. Alic 19 - IV - 2011  =");
 printf ("\n=================================================================");*/


// if (argc==1) {//-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
     // printf("\nSYNTAX: \n\n");
     // printf("\nSTABILOGEN  Input_File  N_time  \n\n");

//---------->> pregunto n�mero de tiempos tomados:
 //printf("\n\n Numero de tiempos tomados : ");
 //scanf("%d", &n_tiempos);

 delimiter = argv[5][0];
  //printf("delim: %c\n", delimiter);

  totalNumTimes = atoi(argv[9]);
//printf("%d\n", argv[10]);

 n_tiempos = atoi(argv[6]);
 //printf("%d\n", n_tiempos);
 /*if (n_tiempos>0)
       printf("\n N_tiempos = %3d \n\n", n_tiempos);
 else */if (n_tiempos <= 0){
       printf("\n Numero de tiempos incorrecto. \n");
       exit(0);
       }

//==================  Reservo MEMORIA  para tiempos =================

 tt = (int *) calloc (n_tiempos, sizeof(int));
 if (tt == NULL)  {
    printf("\n Memory allocation failed.\n");
    exit(EXIT_FAILURE);
    }

//================== Pido tiempos  ====================================
/* for (i=0; i<n_tiempos; i++){
      printf(" Tiempo[%2d] = ", i+1);
      scanf("%d", &tt[i]);
      }*/
char delims[] = "_";
    printf ("%s\n", argv[7]);

    char *tok = strtok(argv[7], delims);
    index = 0;
    while (index < n_tiempos//tok != NULL
    		) {
    	//printf("%s ", tok);
    	tt[index++] = atoi(tok);
    	//printf("%d ", tt[index-1]);
        tok = strtok(NULL, delims);
    }

 //printf("\n\n Tiempos introducidos: ");
 for (i=0; i<n_tiempos; i++){
      //printf("\n %4d : %2d ", i, tt[i] );
      if (i>0) {
                if(tt[i]<=tt[i-1]){
                   printf("\n Error en los valores del los tiempos.");
                   exit(0);
                   }
               }
      }

 if (n_tiempos < totalNumTimes) {
 		printf("%s\n", argv[10]);
 		index = 0;
 		tok = strtok(argv[10], delims);
 		// allocate the number of non-valid columns and add their indeces
 		numTimesIndNotAvail = totalNumTimes - n_tiempos;
 		timesIndNotAvail = (int *) calloc(numTimesIndNotAvail, sizeof(int));
 		while (tok != NULL) {
 			timesIndNotAvail[index++] = atoi(tok);
 				printf("%d ", timesIndNotAvail[index-1]);
 				tok = strtok(NULL, delims);

 			}
     } else //disable discarding in the column discarding function
     	checkFlag = 0;

//---------->> pregunto n�mero de datos del experimento (NN):
 //printf("\n\nNumero de genes del experimento? =  ");
 //scanf("%d", &NN);
 NN = atoi(argv[8]);
 printf("%d\n", NN);
/* if (NN>0)
       printf("\n N_datos = %6d \n", NN);
 else*/ if (NN <= 0){
       printf("\n Numero de datos incorrecto. \n");
       exit(0);
      }

//==================  Reservo MEMORIA  para datos (M y TR):

 M =  (double **)malloc(NN * sizeof(double *));    // per a M
 if (M== NULL){
    printf("\n memory allocation failed.\n");
    exit(EXIT_FAILURE);
    }
 for (i=0; i<NN; i++){
    M[i] = (double *) malloc(n_tiempos * sizeof(double));
    if (M[i]== NULL){
        printf("\n memory allocation failed. \n");
        exit(EXIT_FAILURE);
        }
    }

 TR =  (double **)malloc(NN * sizeof(double *));    // per a TR
 if (TR== NULL){
    printf("\n memory allocation failed.\n");
    exit(EXIT_FAILURE);
    }
 for (i=0; i<NN; i++){
    TR[i] = (double *) malloc(n_tiempos * sizeof(double));
    if (TR[i]== NULL){
        printf("\n memory allocation failed. \n");
        exit(EXIT_FAILURE);
        }
   }

//==================  Inicializo valores de  M  y  TR:
  for (i=0; i<NN; i++){
       for (j=0; j<n_tiempos; j++){
           M[i][j] = 0.0;
           TR[i][j]= 0.0;
           }
       }

//============  Reservo MEMORIA  para datos K_estacionario y K_intervalos

 Kint =  (double **)malloc(NN * sizeof(double *)); //--> per a K_intervalos
 if (Kint== NULL){
    printf("\n memory allocation failed in Kint.\n");
    fflush(stdin); getchar();
    exit(EXIT_FAILURE);
    }
 for (i=0; i<NN; i++){
    Kint[i] = (double *) malloc((n_tiempos) * sizeof(double)); //--> ojo: uno menos
    if (Kint[i]== NULL){
        printf("\n memory allocation failed in Kint[%d]. \n", i);
        fflush(stdin); getchar();
        exit(EXIT_FAILURE);
        }
   }

 Kest = (double *) malloc(NN * sizeof(double)); //--> per a K_estacionario
 if (Kest== NULL){
     printf("\n memory allocation failed in Kest. \n");
     fflush(stdin); getchar();
     exit(EXIT_FAILURE);
     }

//==================  Reservo MEMORIA  para nombre de GENES:

 gen = (char **) malloc(NN * sizeof(char *));    // lista de proteinas.
   if (gen == NULL) {
      printf("\n memory allocation failed.\n");
      exit(EXIT_FAILURE);
      }

   for (i=0; i < NN; i++){
      gen[i] =  (char *) malloc(PALABRA*sizeof(char));
      if (gen[i]== NULL){
         printf("\n memory allocation failed in element gen[%d].\n", i);
         exit(EXIT_FAILURE);
         }
      }
//===============================================================

//---------->> Pregunto por el nombre del fichero de datos:

 fflush(stdin);
 /*do{
      printf("\nInput File ? = ");
      gets(ficha);
      }
 while ((fin=fopen(ficha,"r"))==NULL);*/

 char *fpath = (char *) malloc(sizeof(char) * (strlen(argv[1]) + strlen(argv[2]) + 1));
 strcpy(fpath, argv[1]);
 strcat(fpath, argv[2]);
 fin=fopen(fpath, "r");
 if (fin == NULL) {
	printf("\n Error leer la ficha %s\n", argv[2]);
        exit(EXIT_FAILURE);
 }
 free(fpath);

 //printf ("\n Input File : %s", ficha);
 //exit(0);
//     }//-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+








 //OPEN THE OUTPUT FILE HERE TO BE ABLE TO WRITE THE HEADER IN IT
 //=======================  FICHERO  DE  SALIDA  =========================
  strcpy(ficha_out, argv[1]);
  strcat(ficha_out, argv[3]);  //-----> FICHERO salida
  //strcat(ficha_out, "_A1"); //------> es la primera aplicacion!!

  //sprintf(s_aux, "%d", NN);
  //strcat(ficha_out, "_"); strcat(ficha_out, s_aux);
  //strcat(ficha_out, "_output.txt");
  if ( (fout=fopen(ficha_out,"w"))==NULL) {
        printf ("\n Error opening \"%s\" file.\n", ficha_out);
        exit(0);
        }

  //char headerChar;
    while (fgetc(fin) != '\n')/*{
  	 fputc(headerChar, fout2);
    }*/;
 //Write new header
  fprintf(fout, "Gene", delimiter);
     for (index=0;index<n_tiempos;index++)
  	   fprintf(fout, "%cK(%d)", delimiter, tt[index]);
    fputc('\n', fout);

//======================= LEO DATOS =====================================
 /*printf ("\n\n==========================================================");
 printf ("\n Leyendo datos del fichero ... \n");*/


 for (n=0; n<NN ; n++) {
     strcpy(gen[n], "");
     fscanf(fin, "%s", sss); //-----------> leo linea completa!!!!
     lon_sss= strlen(sss);
     //printf("\n%s\n", sss);  fflush(stdin); //getchar();

     //---> Reconozco nombre del gen:
     if (sss[0]== delimiter) {
          strcpy(gen[n],"----");
          j=1;
          }
     else {
          j=0;
          do {
              s_aux[j]=sss[j];
              j++;
              }
          while (sss[j]!=delimiter);
          s_aux[j]='\0';  //--> fin de string
          strcpy(gen[n], s_aux);
          j++; //--------------> siguiente dato
          // aux1= strlen(gen[n]);
          }
     index = 0;
     //printf("\n[gen-%2d] %6s : ", n+1, gen[n]);
     //-------------> Reconozco valores de TR:
     for (k=0; k<totalNumTimes; k++) {
        // printf("[%d] ", k);
        strcpy(s_aux, "");
        if (sss[j]== delimiter){
            if (isValidCol(k, timesIndNotAvail, numTimesIndNotAvail, checkFlag))
            	TR[n][index++]= NO_DATO;
           j++;
           }
        else {
           con=0;
           do {
              s_aux[con]=sss[j];
              con++; j++;
              }
           while (sss[j]!=delimiter);
           s_aux[con]= '\0'; //--> fin de string
           if (isValidCol(k, timesIndNotAvail, numTimesIndNotAvail, checkFlag))
        	   TR[n][index++]= atof(s_aux);
           j++;//--------------> siguiente dato
           // printf("M[%d]= %5.3f :  ", k, M[n][k]);
           }
        } //------> for(k=0 to n_tiempos)
     index = 0;
     //------------> Reconozco valores de M:
     for (k=0; k<totalNumTimes; k++) {
        // printf("[k=%d, j=%d] ", k, j);
        strcpy(s_aux, "");
        if ((sss[j]== delimiter) || (j==lon_sss)){
            if (isValidCol(k, timesIndNotAvail, numTimesIndNotAvail, checkFlag))
            	M[n][index++]= NO_DATO;
           j++;
           }
        else {
           con=0;
           do {
               // if(k==(n_tiempos-1))
               //   { printf(" {j=%d}", j);  fflush(stdin); getchar(); }

               s_aux[con]=sss[j];
               con++; j++;
               }
           while ((sss[j]!=delimiter) && (j!=lon_sss));
           s_aux[con]= '\0';//--> fin de string
           if (isValidCol(k, timesIndNotAvail, numTimesIndNotAvail, checkFlag))
        	   M[n][index++]= atof(s_aux);
           j++; //--------------> siguiente dato
           // printf(" | TR[%d]= %5.3f : ", k, TR[n][k]);
          }
        }//------> for(k=0 to n_datos)

      } //================>> del for(n=0 to NN)





 //printf ("\n Datos leidos: ");
/* fflush(stdin); getchar();
 for (i=0; i<NN; i++){
     printf("\n%6s", gen[i]); //-----------> veo GEN
     for (j=0; j<n_tiempos; j++)  //---------> veo valores de TR
          if ( TR[i][j]== NO_DATO)
              printf("\t-------");
          else
              printf("  %8.4f", TR[i][j]);
     for (j=0; j<n_tiempos; j++)  //---------> veo valores de M
          if ( M[i][j]== NO_DATO)
              printf("  --------");
          else
              printf("  %8.4f", M[i][j]);
     }*/



// fflush(stdin); getchar();



 /*fprintf (fout,   "=======================================================");
 fprintf (fout, "\n=            S T A B I L O G E N                      =");
 fprintf (fout, "\n=======================================================");
 fprintf (fout, "\n=  V. Arnau; J. Moreno; J. E. Perez;  19 - IV - 2011  =");
 fprintf (fout, "\n=======================================================");
 fprintf (fout, "\n");  */

//========================================================================
//=========  EMPIEZAN LOS CALCULOS :     =================================

//=======================  Calculo de K_estacionario =====================

 for (i=0; i<NN ; i++) {
     if ((TR[i][0]!= NO_DATO) && (M[i][0]!= NO_DATO))
         if (M[i][0]!=0)
              Kest[i] = TR[i][0] / M[i][0];  //--> segun la hoja Excel!!
         else Kest[i] = INFINITO;
     else
         Kest[i] = NO_DATO;
     }

//=======================  Calculo de K_INTERVALOS  =====================

 //printf ("\n\n Calculo los K_INTERVALOS \n (pulsa tecla) ... ");
// fflush(stdin); getchar();



 for (i=0; i<NN ; i++) {
    //printf ("\n%5d \t %6s ", i+1, gen[i]);

    j=0; //------>> Inicializo primer tiempo!!!!

    salgo = 0;
    do {
       if ((TR[i][j]!= NO_DATO) && (M[i][j]!= NO_DATO)) {
          TRini= TR[i][j]; Mini=M[i][j]; t1= tt[j];
          j++;
          salgo=1;
          }
       else {
          Kint[i][j] = NO_DATO;
          j++;
          }
       }
    while ((j<n_tiempos) && (salgo==0));


    while (j<n_tiempos){
       if ((TR[i][j]!= NO_DATO) && (M[i][j]!= NO_DATO)) {
          TRfin= TR[i][j]; Mfin=M[i][j]; t2= tt[j];

          Kint[i][j-1]= fun_K_intervalo(TRini, TRfin, Mini, Mfin, t1, t2); //==>> K_intervalo

          TRini= TRfin; Mini= Mfin; t1=t2;
          j++;
          }
        else {
          Kint[i][j-1]=NO_DATO;
          j++;
          }
        }//----->> del while
    }//--------->>  del for de NN datos


/*
 for (i=0; i<NN ; i++) {
      printf ("\n%5d \t %6s ", i+1, gen[i]);
      for (j=0; j<(n_tiempos-1) ; j++) {
           if (Kint[i][j] != NO_DATO)
               printf ("\t %7.4f ", Kint[i][j]);
           else
               printf ("\t ------- ");
           }
    }//--------->>  del for de NN datos
*/

// fflush(stdin); getchar();
// printf ("\n\n Pulsa techa y a fichero !!! \n");
// fflush(stdin); getchar();


//========================================================================
//=========    Resultados a fichero      =================================

 /*fprintf (fout, "\n    N\t    Gen \t  Kestac");
 fprintf (fout, "\n-------------------------------------------------------");*/

 for (i=0; i<NN ; i++) {
      //printf ("\n%5d ; %6s ", i+1, gen[i]);//"\n%5d \t %6s ", i+1, gen[i]);
      //fprintf (fout, "\n%5d; %6s ", i+1, gen[i]);//"\n%5d\t %6s ", i+1, gen[i]);
      //fprintf (fout, "%s", gen[i]);//"\n%5d\t %6s ", i+1, gen[i]);
      if (Kest[i]!= NO_DATO){
          if (Kest[i]!= INFINITO) {
        	  fprintf (fout, "%s%c%8.6f", gen[i], delimiter, Kest[i]);
              //fprintf (fout, "%c%8.6f", delimiter, Kest[i]);//"\t %9.6f", Kest[i]);
          } else continue;
          //fprintf (fout, "%c--INF-- ", delimiter);//"\t --INF-- ");
          }
      else {
    	  fprintf (fout, "%s%c", gen[i], delimiter);
          //fprintf (fout, "%c", delimiter);//"\t ------- ");
      }

      //--------->> Imprimo los valores de K_estacionario:
       for (j=0; j<(n_tiempos-1) ; j++) {
           if (Kint[i][j] != NO_DATO)
               fprintf (fout, "%c%8.6f", delimiter, Kint[i][j]);//"\t %9.6f", Kint[i][j]);
           else
               fprintf (fout, "%c", delimiter);//"\t ------- ");
           }
       fprintf (fout, "\n");

     }



 /*fprintf (fout, "\n=======================================================");*/


//========================================================================

 fclose(fin); fclose(fout);

 for (n=0; n<NN ; n++) {
      free(M[n]); free(TR[n]); free(gen[n]); free(Kint[n]);
      }
  free(M); free(TR); free(Kest); free(Kint);
  if (n_tiempos < totalNumTimes)
 	 free(timesIndNotAvail);
  free(tt);
  free(gen);
 //printf ("\n\n Fin de programa !!! \n");
 fflush(stdin); //getchar();
 printf(argv[4]);

}





//*************************************************************************
//==============   FUNCION   ==============================================

double fun_K_intervalo(double TR1, double TR2, double M1, double M2, int tt1, int tt2)
{
 double   k_intervalo = 1.0;
 double   p, faux;
 double   F1, F2; //--> parte izquieda y derecha de la funci�n.
 double   dif, mdif, k1, k2, vk;
 int      cont, caso;


/* printf("\n\n TR1=%9.6f  TR2=%9.6f  M1=%9.6f  M2=%9.6f  (%d-%d)",
         TR1, TR2, M1, M2, tt2, tt1);*/

 p = (TR2- TR1)/(tt2-tt1);

 vk = EPSILON; //---->> Compruebo a que lado estoy del 0:
 F1 = p - (TR2*vk) + (M2 * vk * vk);
 faux= vk * (tt2-tt1);
 F2 = (exp(-faux)) *  (p - (TR1*vk) + (M1 * vk * vk));
 dif= F1 - F2;

 if (dif<0) {caso=1; k1= EPSILON;   k2= 1.0;}
 else       {caso=2; k1= -1;   k2= -EPSILON;}


//----->> Busco punto de cruce de F1 y F2 por la derecha de 0:

 if (caso == 1){
    do{
       F1 = p - (TR2*k2) + (M2 * k2 *k2);
       faux= k2 * (tt2-tt1);
       F2 = (exp(-faux)) *  (p - (TR1*k2) + (M1 * k2 *k2));
       dif= F1 - F2;
       if (dif<0) k2++;
      }
    while (dif<0);
    }
 if (caso == 2){
    do{
       F1 = p - (TR2*k1) + (M2 * k1 *k1);
       faux= k1 * (tt2-tt1);
       F2 = (exp(-faux)) *  (p - (TR1*k1) + (M1 * k1 *k1));
       dif= F1 - F2;
       if (dif<0) k1--;
      }
    while (dif>0);
    }


//  printf("\n Valor K2 = %9.6f \n", k2);

 p = (TR2- TR1)/(tt2-tt1);
 cont=0;
 do {
     vk = k1 + ((k2-k1)/2.0); //--> punto a probar: ojo con el detalle!!.

    F1 = p - (TR2*vk) + (M2 * vk * vk);
    faux= vk * (tt2-tt1);
    F2 = (exp(-faux)) *  (p - (TR1*vk) + (M1 * vk * vk));
    dif= F1 - F2;

     //printf("\n vk= %9.6f --> dif = %9.6f ", vk, dif);

     if (dif>0.0) k2=vk;
     else         k1=vk;




     cont++;  //      printf("+");
     if (dif<0) mdif = -dif; //--> ojo: el modulo de la diferencia!!
     else       mdif =  dif;
     }
 while ((mdif>EPSILON) && (cont<50));


 //printf("\n [c=%d] Valor K = %9.6f", cont,  vk);


 return(vk);

}
//*************************************************************************


