# This is the Shutoff algorithms which applies a natural log normalization on the values and then calculates the spearman coef and Kd
# args[1] = the path of the current experiment
# args[2] = the name of the input file
# args[3] = the name of the output file
# args[4] = success message
# args[5] = what experiment times to use (TR; RA; TR and RA;Time point)
# args[6] = separator of data in the source file
# args[7] = array of times to be used in the correlation

.libPaths('lib/linux/')

# load the common part of the algorithms ##
source("/home/andrei/univ/master/eclipse_workspace/PFC/src/pfc/protected/commands/shell/r/common.R")
#source("/home/andrei/sitio/PFC/src/pfc/protected/commands/shell/r/common.R")


args <- commandArgs(TRUE)
# args[1] <- "/home/andrei/univ/master/eclipse_workspace/PFC/docs/data_of_pfc/"
# args[2] <- "Datos_40_good.csv"
# args[3] <- "result_shutoff"
# args[4] <- "succ"
# args[5] <- .EXP_TIMES_TR
# args[6] <- ";"
# 
# args[7] <- "0_2_4_6_8_10_15"

data <- prepareInput(args[1], args[2], args[5], args[6], .NORM_METHOD_NONE, .NORM_METHOD_WHEN_AFT_CL);

times <- as.numeric(t(unlist(
  strsplit(args[7], split='_', fixed=TRUE))))

print('exptimes log')
#matrixData <- #sweep(as.matrix(matrixData), 1, column, "/")
numCols = ncol(data)
for (i in 1:numCols) {
  data[,i] <- log(as.double(as.vector(data[,i])))
}

geneNames <- rownames(data)
data <- as.matrix(data)
numRows = nrow(data)
correlations <- c();
## pre-Calculate the value for the SD for times since it will be used for each gene in the file
sdTimes <- sd(times)
for (i in 1:numRows) {
  #print(times)
  #print(as.vector(data[i,]))
  #print(cor(x = as.vector(data[i,]), y = times, method="spearman"))
  rowData <- as.vector(data[i,])
  corData <- cor(x = rowData, y = times, method="spearman")
  geneNames[i] = paste(sep=';', 
                paste(sep=';', geneNames[i], corData), 
                       corData*(sdTimes/sd(rowData)))
  #as.numeric((lm(times~rowData))$coeff[2])),
}
fileFPath <- paste(sep='', args[1], paste(sep='', args[3], '.csv'))
## Write header
write(paste(sep=';', 'Gene name', paste(sep=';','rho (spearman)', 'Kd (slope)' )), file = fileFPath, sep='\n', 
      ncolumns = 1)
## Write data determined earlier
write(geneNames, file = fileFPath, sep='\n', 
      ncolumns = 1, append = TRUE)

#correlations <- cor(x = data, y = times, method="spearman")
# print(nrow(data))
# print(data)
# print(length(correlations))
# print(correlations)
print(args[4])


