SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

DROP SCHEMA IF EXISTS `pfc` ;
CREATE SCHEMA IF NOT EXISTS `pfc` DEFAULT CHARACTER SET latin1 ;
USE `pfc` ;

-- -----------------------------------------------------
-- Table `pfc`.`pfc_fileitem`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_fileitem` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_fileitem` (
  `id` INT(11) NOT NULL AUTO_INCREMENT ,
  `diskName` VARCHAR(200) NOT NULL ,
  `name` VARCHAR(80) NOT NULL ,
  `size` INT(11) NOT NULL ,
  `fileType` INT(11) NOT NULL ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) )
ENGINE = InnoDB
AUTO_INCREMENT = 78
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_user`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_user` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_user` (
  `id` INT(11) NOT NULL AUTO_INCREMENT ,
  `username` VARCHAR(30) NOT NULL ,
  `password` VARCHAR(45) NOT NULL ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `id_user_UNIQUE` (`id` ASC) ,
  UNIQUE INDEX `username_UNIQUE` (`username` ASC) )
ENGINE = InnoDB
AUTO_INCREMENT = 24
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_experiment`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_experiment` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_experiment` (
  `id` INT(11) NOT NULL AUTO_INCREMENT ,
  `id_user` INT(11) NOT NULL ,
  `title` VARCHAR(25) NOT NULL ,
  `date` BIGINT(20) NOT NULL ,
  `description` VARCHAR(200) NULL DEFAULT NULL ,
  `path` VARCHAR(500) NOT NULL ,
  `id_fileitem` INT(11) NULL DEFAULT NULL ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) ,
  INDEX `fk_userid` (`id_user` ASC) ,
  INDEX `fk_user_id` (`id_user` ASC) ,
  INDEX `fk_file_item` (`id_fileitem` ASC) ,
  CONSTRAINT `fk_file_item`
    FOREIGN KEY (`id_fileitem` )
    REFERENCES `pfc`.`pfc_fileitem` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_user_id`
    FOREIGN KEY (`id_user` )
    REFERENCES `pfc`.`pfc_user` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB
AUTO_INCREMENT = 65
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_fileitemdata`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_fileitemdata` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_fileitemdata` (
  `id_fileitem` INT(11) NOT NULL ,
  `numGenes` INT(11) NOT NULL ,
  `delimiter` CHAR(1) NOT NULL ,
  `hasNA` TINYINT(1) NOT NULL ,
  PRIMARY KEY (`id_fileitem`) ,
  UNIQUE INDEX `id_fileitem_UNIQUE` (`id_fileitem` ASC) ,
  INDEX `fk_fileitemdata_fileitem` (`id_fileitem` ASC) ,
  CONSTRAINT `fk_fileitemdata_fileitem`
    FOREIGN KEY (`id_fileitem` )
    REFERENCES `pfc`.`pfc_fileitem` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_fileitemdatatimepoint`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_fileitemdatatimepoint` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_fileitemdatatimepoint` (
  `id_fileitemdata` INT(11) NOT NULL ,
  `numTimePoint` INT(11) NOT NULL ,
  PRIMARY KEY (`id_fileitemdata`) ,
  UNIQUE INDEX `id_fileitemdata_UNIQUE` (`id_fileitemdata` ASC) ,
  INDEX `fk_fileitemdatatimepoint_fileitemdata` (`id_fileitemdata` ASC) ,
  CONSTRAINT `fk_fileitemdatatimepoint_fileitemdata`
    FOREIGN KEY (`id_fileitemdata` )
    REFERENCES `pfc`.`pfc_fileitemdata` (`id_fileitem` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_fileitemdatatrra`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_fileitemdatatrra` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_fileitemdatatrra` (
  `id_fileitemdata` INT(11) NOT NULL ,
  `numRA` INT(11) NOT NULL ,
  `numTR` INT(11) NOT NULL ,
  PRIMARY KEY (`id_fileitemdata`) ,
  UNIQUE INDEX `id_fileitemdata_UNIQUE` (`id_fileitemdata` ASC) ,
  INDEX `fk_fileitemdatatrra_fileitemdata` (`id_fileitemdata` ASC) ,
  CONSTRAINT `fk_fileitemdatatrra_fileitemdata`
    FOREIGN KEY (`id_fileitemdata` )
    REFERENCES `pfc`.`pfc_fileitemdata` (`id_fileitem` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_fileitemdataarr`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_fileitemdataarr` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_fileitemdataarr` (
  `value` INT(11) NOT NULL ,
  `id` INT(11) NOT NULL AUTO_INCREMENT ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `idFileItemDataTRRA_UNIQUE` (`id` ASC) )
ENGINE = InnoDB
AUTO_INCREMENT = 8
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_operation`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_operation` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_operation` (
  `id` INT(11) NOT NULL AUTO_INCREMENT ,
  `id_experiment` INT NOT NULL ,
  `algorithmType` SMALLINT NOT NULL ,
  `operationType` SMALLINT NOT NULL ,
  `date` BIGINT NOT NULL ,
  `experimentTimes` SMALLINT NOT NULL ,
  `description` VARCHAR(200) NULL ,
  `title` VARCHAR(25) NOT NULL ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) ,
  INDEX `fk_operation_experiment` (`id_experiment` ASC) ,
  CONSTRAINT `fk_operation_experiment`
    FOREIGN KEY (`id_experiment` )
    REFERENCES `pfc`.`pfc_experiment` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_filternaform`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_filternaform` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_filternaform` (
  `id_operation` INT NOT NULL ,
  `perAllowedNA` INT NOT NULL ,
  PRIMARY KEY (`id_operation`) ,
  UNIQUE INDEX `id_operation_UNIQUE` (`id_operation` ASC) ,
  INDEX `fk_filternaform_operation` (`id_operation` ASC) ,
  CONSTRAINT `fk_filternaform_operation`
    FOREIGN KEY (`id_operation` )
    REFERENCES `pfc`.`pfc_operation` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_input`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_input` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_input` (
  `id_operation` INT NOT NULL ,
  `id_fileitem` INT NOT NULL ,
  INDEX `fk_input_operation` (`id_operation` ASC) ,
  INDEX `fk_input_fileitem` (`id_fileitem` ASC) ,
  UNIQUE INDEX `id_operation_UNIQUE` (`id_operation` ASC) ,
  PRIMARY KEY (`id_operation`) ,
  CONSTRAINT `fk_input_operation`
    FOREIGN KEY (`id_operation` )
    REFERENCES `pfc`.`pfc_operation` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_input_fileitem`
    FOREIGN KEY (`id_fileitem` )
    REFERENCES `pfc`.`pfc_fileitem` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_result`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_result` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_result` (
  `id_operation` INT NOT NULL ,
  `id_fileitem` INT NOT NULL ,
  `message` VARCHAR(300) NULL ,
  INDEX `fk_result_operation` (`id_operation` ASC) ,
  INDEX `fk_result_fileitem` (`id_fileitem` ASC) ,
  UNIQUE INDEX `id_operation_UNIQUE` (`id_operation` ASC) ,
  PRIMARY KEY (`id_operation`) ,
  CONSTRAINT `fk_result_operation`
    FOREIGN KEY (`id_operation` )
    REFERENCES `pfc`.`pfc_operation` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_result_fileitem`
    FOREIGN KEY (`id_fileitem` )
    REFERENCES `pfc`.`pfc_fileitem` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_clusterform`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_clusterform` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_clusterform` (
  `id_operation` INT NOT NULL ,
  `voutType` INT NOT NULL ,
  `voutFormat` INT NOT NULL ,
  `normMethod` INT NOT NULL ,
  `replaceWithClRes` INT NOT NULL ,
  `whenApplyNorm` INT NOT NULL ,
  `heatmapCol` INT NOT NULL ,
  PRIMARY KEY (`id_operation`) ,
  UNIQUE INDEX `id_operation_UNIQUE` (`id_operation` ASC) ,
  INDEX `fk_clusterform_operation` (`id_operation` ASC) ,
  CONSTRAINT `fk_clusterform_operation`
    FOREIGN KEY (`id_operation` )
    REFERENCES `pfc`.`pfc_operation` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_kmeansform`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_kmeansform` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_kmeansform` (
  `id_clusterform` INT NOT NULL ,
  `clusters` INT NOT NULL ,
  `maxNumIterations` INT NOT NULL ,
  `numRandSets` INT NOT NULL ,
  `clusterDisplay` INT NOT NULL ,
  `distMethod` VARCHAR(45) NOT NULL ,
  PRIMARY KEY (`id_clusterform`) ,
  UNIQUE INDEX `id_operation_UNIQUE` (`id_clusterform` ASC) ,
  INDEX `fk_kmeansform_clusterform` (`id_clusterform` ASC) ,
  CONSTRAINT `fk_kmeansform_clusterform`
    FOREIGN KEY (`id_clusterform` )
    REFERENCES `pfc`.`pfc_clusterform` (`id_operation` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_kmeanscenters`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_kmeanscenters` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_kmeanscenters` (
  `id` INT NOT NULL AUTO_INCREMENT ,
  `value` FLOAT NOT NULL ,
  `type` INT NULL ,
  `id_kmeansform` INT NOT NULL ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) ,
  INDEX `fk_kmeanscenters_kmeansform` (`id_kmeansform` ASC) ,
  CONSTRAINT `fk_kmeanscenters_kmeansform`
    FOREIGN KEY (`id_kmeansform` )
    REFERENCES `pfc`.`pfc_kmeansform` (`id_clusterform` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_sotaform`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_sotaform` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_sotaform` (
  `id_clusterform` INT NOT NULL ,
  `maxCycles` INT NOT NULL ,
  `maxEpochs` INT NOT NULL ,
  `distMethod` VARCHAR(45) NOT NULL ,
  `wcell` DOUBLE NOT NULL ,
  `pcell` DOUBLE NOT NULL ,
  `scell` DOUBLE NOT NULL ,
  `delta` DOUBLE NOT NULL ,
  `neighbLevel` INT NOT NULL ,
  `maxDiversity` DOUBLE NOT NULL ,
  `unrestGrowth` TINYINT(1) NOT NULL ,
  PRIMARY KEY (`id_clusterform`) ,
  UNIQUE INDEX `id_operation_UNIQUE` (`id_clusterform` ASC) ,
  INDEX `fk_sotaform_clusterform` (`id_clusterform` ASC) ,
  CONSTRAINT `fk_sotaform_clusterform`
    FOREIGN KEY (`id_clusterform` )
    REFERENCES `pfc`.`pfc_clusterform` (`id_operation` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_upgmaform`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_upgmaform` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_upgmaform` (
  `id_clusterform` INT NOT NULL ,
  `aggMethod` VARCHAR(45) NOT NULL ,
  `dendroCutType` INT NOT NULL ,
  `dendroCutVal` DOUBLE NOT NULL ,
  `distMethod` VARCHAR(45) NOT NULL ,
  PRIMARY KEY (`id_clusterform`) ,
  UNIQUE INDEX `id_clusterform_UNIQUE` (`id_clusterform` ASC) ,
  INDEX `fk_upgmaform_clusterform` (`id_clusterform` ASC) ,
  CONSTRAINT `fk_upgmaform_clusterform`
    FOREIGN KEY (`id_clusterform` )
    REFERENCES `pfc`.`pfc_clusterform` (`id_operation` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_resultcluster`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_resultcluster` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_resultcluster` (
  `id_result` INT NOT NULL ,
  `id_fileitem_filedata` INT NULL ,
  `id_fileitem_filecluster` INT NULL ,
  PRIMARY KEY (`id_result`) ,
  UNIQUE INDEX `id_result_UNIQUE` (`id_result` ASC) ,
  INDEX `fk_resultcluster_fileitem_filedata` (`id_fileitem_filedata` ASC) ,
  INDEX `fk_resultcluster_fileitem_filecluster` (`id_fileitem_filecluster` ASC) ,
  INDEX `fk_resultcluster_result` (`id_result` ASC) ,
  CONSTRAINT `fk_resultcluster_fileitem_filedata`
    FOREIGN KEY (`id_fileitem_filedata` )
    REFERENCES `pfc`.`pfc_fileitem` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_resultcluster_fileitem_filecluster`
    FOREIGN KEY (`id_fileitem_filecluster` )
    REFERENCES `pfc`.`pfc_fileitem` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_resultcluster_result`
    FOREIGN KEY (`id_result` )
    REFERENCES `pfc`.`pfc_result` (`id_operation` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_analyseform`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_analyseform` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_analyseform` (
  `id_operation` INT NOT NULL ,
  PRIMARY KEY (`id_operation`) ,
  UNIQUE INDEX `id_operation_UNIQUE` (`id_operation` ASC) ,
  INDEX `fk_pfc_analyseform_operation` (`id_operation` ASC) ,
  CONSTRAINT `fk_pfc_analyseform_operation`
    FOREIGN KEY (`id_operation` )
    REFERENCES `pfc`.`pfc_operation` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_analysekresform`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_analysekresform` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_analysekresform` (
  `id_analyseform` INT NOT NULL ,
  `numGenes` INT NOT NULL ,
  PRIMARY KEY (`id_analyseform`) ,
  UNIQUE INDEX `id_operation_UNIQUE` (`id_analyseform` ASC) ,
  INDEX `fk_pfc_analysekresform_operation` (`id_analyseform` ASC) ,
  CONSTRAINT `fk_pfc_analysekresform_operation`
    FOREIGN KEY (`id_analyseform` )
    REFERENCES `pfc`.`pfc_analyseform` (`id_operation` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_analysekresformaddedtimes`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_analysekresformaddedtimes` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_analysekresformaddedtimes` (
  `idanalyseformaddedTimes` INT NOT NULL AUTO_INCREMENT ,
  `id_analysekresform` INT NOT NULL ,
  `value` INT NOT NULL ,
  PRIMARY KEY (`idanalyseformaddedTimes`) ,
  UNIQUE INDEX `id_addedTimes_UNIQUE` (`idanalyseformaddedTimes` ASC) ,
  INDEX `fk_pfc_analyseformaddedtimes_analyseform` (`id_analysekresform` ASC) ,
  CONSTRAINT `fk_pfc_analyseformaddedtimes_analyseform`
    FOREIGN KEY (`id_analysekresform` )
    REFERENCES `pfc`.`pfc_analysekresform` (`id_analyseform` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `pfc`.`pfc_fileitemdataarrlink`
-- -----------------------------------------------------
DROP TABLE IF EXISTS `pfc`.`pfc_fileitemdataarrlink` ;

CREATE  TABLE IF NOT EXISTS `pfc`.`pfc_fileitemdataarrlink` (
  `id_fileitemdata` INT NOT NULL ,
  `id_fileitemdataarr` INT NOT NULL ,
  `id` INT NOT NULL AUTO_INCREMENT ,
  INDEX `fk_fileitemdataarrlink_fileitemdataarr` (`id_fileitemdataarr` ASC) ,
  INDEX `fk_pfc_fileitemdataarrlink_fileitemdata` (`id_fileitemdata` ASC) ,
  PRIMARY KEY (`id`) ,
  UNIQUE INDEX `id_UNIQUE` (`id` ASC) ,
  UNIQUE INDEX `id_fileitemdataarr_UNIQUE` (`id_fileitemdataarr` ASC) ,
  CONSTRAINT `fk_fileitemdataarrlink_fileitemdataarr`
    FOREIGN KEY (`id_fileitemdataarr` )
    REFERENCES `pfc`.`pfc_fileitemdataarr` (`id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_pfc_fileitemdataarrlink_fileitemdata`
    FOREIGN KEY (`id_fileitemdata` )
    REFERENCES `pfc`.`pfc_fileitemdata` (`id_fileitem` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
