<?php
/**
 * Keeps all the data necessary for database operations, especially the name of the columns in the database
 * for each table which must be mapped onto the corresponding class in the code
 * @author andrei
 *
 */
class SqlUtil {
	
	const ERR_USER_REG = 'ERR_USER_REG';
	
	const FILEITEM_TBL = '{{fileitem}}';
	const FILEITEM_DISKNAME = 'diskName';
	const FILEITEM_NAME = 'name';
	const FILEITEM_SIZE = 'size';	
	const FILEITEM_FILETYPE = 'fileType';	
	
	const FILEITEMDATA_TBL = '{{fileitemdata}}';
	const FILEITEMDATA_FILEITEM_FK = 'id_fileitem';
	const FILEITEMDATA_NUMGENES = 'numGenes';
	const FILEITEMDATA_DELIMITER = 'delimiter';
	const FILEITEMDATA_HASNA = 'hasNA';
	
	const FILEITEMDATAARRLINK_TBL = '{{fileitemdataarrlink}}';
	const FILEITEMDATAARRLINK_FILEITEMDATA_FK = 'id_fileitemdata';
	const FILEITEMDATAARRLINK_FILEITEMDATAARR_FK = 'id_fileitemdataarr';
	
	const FILEITEMDATATIMEPOINT_TBL = '{{fileitemdatatimepoint}}';
	const FILEITEMDATATIMEPOINT_FILEITEMDATA_FK = 'id_fileitemdata';
	const FILEITEMDATATIMEPOINT_NUMTIMEPOINT = 'numTimePoint';
	
	const FILEITEMDATAARR_TBL = '{{fileitemdataarr}}';
	const FILEITEMDATAARR_FILEITEMDATA_FK  = 'id_fileitemdata';
	const FILEITEMDATAARR_VALUE = 'value';
	
	const FILEITEMDATATRRA_TBL = '{{fileitemdatatrra}}';
	const FILEITEMDATATRRA_FILEITEMDATA_FK = 'id_fileitemdata';
	const FILEITEMDATATRRA_NUMRA_COL = 'numRA';
	const FILEITEMDATATRRA_NUMTR_COL = 'numTR';
	
	const OPERATION_TBL = '{{operation}}';
	const OPERATION_EXPERIMENT_FK = 'id_experiment';
	const OPERATION_ALGORITHMTYPE = 'algorithmType';
	const OPERATION_OPERATIONTYPE = 'operationType';
	const OPERATION_DATE = 'date';
	const OPERATION_EXPERIMENTTIMES = 'experimentTimes';
	const OPERATION_DESCRIPTION = 'description';
	const OPERATION_TITLE = 'title';
	
	const INPUT_TBL = '{{input}}';
	const INPUT_OPERATION_FK = 'id_operation';
	const INPUT_FILEITEM_FK = 'id_fileitem';
	
	const RESULT_TBL = '{{result}}';
	const RESULT_OPERATION_FK = 'id_operation';
	const RESULT_FILEITEM_FK = 'id_fileitem';
	const RESULT_MESSAGE = 'message';
	
	const RESULTCLUSTER_TBL = '{{resultcluster}}';
	const RESULTCLUSTER_RESULT_FK = 'id_result';
	const RESULTCLUSTER_FILEITEM_FILEDATA_FK = 'id_fileitem_filedata';
	const RESULTCLUSTER_FILEITEM_FILECLUSTER_FK = 'id_fileitem_filecluster';
	
	const ANALYSEFORM_TBL = '{{analyseform}}';
	const ANALYSEFORM_OPERATION_FK = 'id_operation';
	
	const ANALYSEKRESFORM_TBL = '{{analysekresform}}';
	const ANALYSEKRESFORM_ANALYSEFORM_FK = 'id_analyseform';
	const ANALYSEKRESFORM_NUMGENES = 'numGenes';
	
	const ANALYSEKRESFORMADDEDTIMES_TBL = '{{analysekresformaddedtimes}}';
	const ANALYSEKRESFORMADDEDTIMES_ANALYSEKRESFORM_FK = 'id_analysekresform';
	const ANALYSEKRESFORMADDEDTIMES_VALUE = 'value';
	
	const SHUTOFFFORM_TBL = '{{shutoffform}}';
	const SHUTOFFFORM_ANALYSEFORM_FK = 'id_analyseform';
	
	const CLUSTERFORM_TBL = '{{clusterform}}';
	const CLUSTERFORM_OPERATION_FK = 'id_operation';
	const CLUSTERFORM_VOUTTYPE = 'voutType';
	const CLUSTERFORM_VOUTFORMAT = 'voutFormat';
	const CLUSTERFORM_NORMMETHOD = 'normMethod';
	const CLUSTERFORM_REPLACEWITHCLRES = 'replaceWithClRes';
	const CLUSTERFORM_WHENAPPLYNORM = 'whenApplyNorm';
	const CLUSTERFORM_HEATMAPCOL = 'heatmapCol';
	
	const KMEANSFORM_TBL ='{{kmeansform}}';
	const KMEANSFORM_CLUSTERFORM_FK ='id_clusterform';
	const KMEANSFORM_CLUSTERS ='clusters';
	const KMEANSFORM_MAXNUMITERATIONS ='maxNumIterations';
	const KMEANSFORM_NUMRANDSETS ='numRandSets';
	const KMEANSFORM_DISTMETHOD ='distMethod';
	const KMEANSFORM_CLUSTERDISPLAY ='clusterDisplay';
	
	const KMEANSCENTERS_TBL ='{{kmeanscenters}}';
	const KMEANSCENTERS_KMEANSFORM_FK ='id_kmeansform';
	const KMEANSCENTERS_VALUE ='value';
	const KMEANSCENTERS_TYPE ='type';
	
	const SOTAFORM_TBL = '{{sotaform}}';
	const SOTAFORM_CLUSTERFORM_FK ='id_clusterform';
	const SOTAFORM_MAXCYCLES ='maxCycles';
	const SOTAFORM_MAXEPOCHS ='maxEpochs';
	const SOTAFORM_DISTMETHOD ='distMethod';
	const SOTAFORM_WCELL ='wcell';
	const SOTAFORM_PCELL ='pcell';
	const SOTAFORM_SCELL ='scell';
	const SOTAFORM_DELTA ='delta';
	const SOTAFORM_NEIGHBLEVEL ='neighbLevel';
	const SOTAFORM_MAXDIVERSITY ='maxDiversity';
	const SOTAFORM_UNRESTGROWTH ='unrestGrowth';
	
	const UPGMAFORM_TBL = '{{upgmaform}}';
	const UPGMAFORM_CLUSTERFORM_FK ='id_clusterform';
	const UPGMAFORM_AGGMETHOD = 'aggMethod';
	const UPGMAFORM_DISTHMETHOD = 'distMethod';
	const UPGMAFORM_DENDROCUTTYPE = 'dendroCutType';
	const UPGMAFORM_DENDROCUTVAL = 'dendroCutVal';
	
	const FILTERNAFORM_TBL = '{{filternaform}}';
	const FILTERNAFORM_OPERATION_FK = 'id_operation';
	const FILTERNAFORM_PERALLOWEDNA = 'perAllowedNA';
	
	const USER_TBL = '{{user}}';
	const EXPERIMENT_TBL = '{{experiment}}';
	const EXPERIMENT_USER_FK = 'id_user';
	const EXPERIMENT_FILEITEM_FK = 'id_fileitem';
	const EXPERIMENT_TITLE_COL = 'title';
	const EXPERIMENT_DESCR_COL = 'description';
	const EXPERIMENT_DATE_COL = 'date';
	const ID_COL = 'id';
	const USER_USERNAME_COL = 'username';
	const USER_PASSWORD_COL = 'password';
	
	const USER_LOGIN_CHECK = 'SELECT name, password FROM {{user}}';
	const USER_REGISTER = 'INSERT INTO {{user}} (username, password) VALUES (:username, :password)';
	const FILEITEMDATAARR_INSERT = 'INSERT INTO :table (:id_col, value) VALUES (:username, :password)';
	
	const FILEITEMDATAARR_DELETE = 'DELETE  arr.* FROM pfc_fileitemdataarr AS arr LEFT JOIN pfc_fileitemdataarrlink AS fllnk ON arr.id = fllnk.id_fileitemdataarr WHERE fllnk.id_fileitemdata = :fileID';
	/**
	 * Method which searches in botht the Input and Result tables to determine if a certain file is refered
	 * by more than 1 of these kind of objects
	 * @param int $idFile The id of the file checked
	 */
	public static function isFileUniRef($idFile) {
		$fResult = Yii::app()->db->createCommand()->select('COUNT(id)') 
			->from(SqlUtil::RESULT_TBL)->where(SqlUtil::RESULT_FILEITEM_FK.' = '.$idFile);
		if ($fResult > 1)
			return false;
		$fInput = Yii::app()->db->createCommand()->select('COUNT(*)')
			->from(SqlUtil::INPUT_TBL)->where(SqlUtil::INPUT_FILEITEM_FK.' = '.$idFile);
		if ($fInput > 1 ||
				($fInput > 0 && $fResult > 0))
			return false;
		else 
			return true;
	}
	
}