<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity
{
	public $id;
	
	
	public function __construct($username, $password, $id = 0) {
		parent::__construct($username, $password);
		$this->id = $id;
	}
	
	/**
	 * Authenticates a user.
	 * The example implementation makes sure if the username and password
	 * are both 'demo'.
	 * In practical applications, this should be changed to authenticate
	 * against some persistent user identity storage (e.g. database).
	 * @return boolean whether authentication succeeds.
	 */
	public function authenticate()
	{
		$connection = Yii::app()->db;
		$dataReader = $connection->createCommand() ->select(SqlUtil::ID_COL.', '.SqlUtil::USER_USERNAME_COL.', '.SqlUtil::USER_PASSWORD_COL)
    		->from(SqlUtil::USER_TBL)
    		->where(array('and', 'username=:username', 'password=:password'), 
    				array(':username'=>$this->username,
    				':password'=>$this->password))
    		->queryRow();
		// bind the 1st column (username) with the $username variable
 		
// 		$dataReader->bindColumn(2, $username);
// 		$dataReader->bindColumn(3, $password);
// 		// bind the 2nd column (email) with the $email variable
// 		$dataReader->bindColumn(2, $password);
// 		while($dataReader->read()!==false)
// 		{
// 		    // $username and $email contain the username and email in the current row
// 		}
		if($dataReader == false)
			$this->errorCode=self::ERROR_UNKNOWN_IDENTITY;
// 		else if($users[$this->username]!==$this->password)
// 			$this->errorCode=self::ERROR_PASSWORD_INVALID;
		else {
			//if there are rows bind the id and set the current id
			//$dataReader->bindValue('id', $id);
			$this->id = $dataReader[SqlUtil::ID_COL];
			$this->errorCode=self::ERROR_NONE;
		}
		return !$this->errorCode;
	}
	
	public function getId() {
		return $this->id;
	}
	
}