<?php
/**
 * Class implementing a whole set of utilities used all over the application
 * @author andrei
 *
 */

class Util 
{
	/** @const int The max length for a title for operations and experiment */
	const TITLE_LEN = 25;
	/** @const int  The max length for a description for operations and experiment */
	const DESC_LEN = 200;
	
	const ID_UNDEFINED = -1;
	/** @const int how many seconds should the session be active; after that it is distroyed */
	const SESSION_TIMEOUT = 1800;//30 minutes
	/** @const int How many miliseconds should the session expire warning be delayed */
	const TIME_COUNT_BEF_SES_TO_WARN = 1500000;//25 min
	
	/**
	 * Method to check if the session has expired or not; It uses the start variable which gets stored on the session
	 * once a new session is opened;  
	 */
	public static function sessionCheck() {
		if (isset(Yii::app()->session)) {
			//$inactive = 5;
			// check to see if $_session['timeout'] is set
			if(//isset(Yii::app()->session['timeout']) && 
					isset(Yii::app()->session['start']))
			{
				$session_life = time() - Yii::app()->session['start'];
				if($session_life > Util::SESSION_TIMEOUT) {
					if (!Yii::app()->user->isGuest)
						Yii::app()->user->logout(true);
					else
						Yii::app()->session->destroy(); 
					Yii::app()->controller->redirect(Yii::app()->createUrl('site/info', 
							array('message'=>Yii::t('lstrings', 'MSG_SESSION_EXPIRED'))));
					//header("Location: logoutpage.php");
				}
				Yii::app()->session['start'] = time();
				//Yii::app()->session['timeout'] = time();
			}
		}
	}

	/**
	 * @return boolean A session exists and the verification should be done in this case
	 */
	public  static function isCheckSession() {
		return isset(Yii::app()->session['start']);
	}
	
	public static function generateHelp($id, $style = '') {
		 return CHtml::link(CHtml::image('/images/info.png'), NULL, array(
		 		'class' => 'btnHelpD',
				'style' => 'margin-right: 2%; cursor: pointer; '.$style,
				'onclick' => 'showUrlInDialog("'.$id.'")' ));
		/* return CHtml::imageButton('/images/info.png', array(
				'style' => 'margin: 0',
				'value' => 'button',
				'onclick' => 'showUrlInDialog("'.$id.'")' )); */
	}
	
	public static function generateRequiredStar($style = '') {
		return '<span style="color: red;">*</span>';
	}
	
	/**
	 * Recursively remove a directory and everything what's inside
	 * @param string $dir The path to the directory to be removed along with its contents
	 */
	public static function  recRmdir($dir) {
		foreach(glob($dir . '/*') as $file) {
			if(is_dir($file))
				rrmdir($file);
			else
				unlink($file);
		}
		rmdir($dir);
	}
	
	/**
	 * Use this function to generate a zip file; This version doesn't add directorie recursively
	 * @param string $dir Source directory with the target files 
	 * @param array FileItem $files List of files which will be added in the archive
	 * @param string $destination Destination directory where the archive will reside
	 * @return boolean the whole process worked
	 */
	public static function zip($dir, array $files, $destination)	{
		if (!extension_loaded('zip')) {
			return false;
		}
		$source = str_replace('\\', '/', realpath($dir));
		$zip = new ZipArchive();
		if (!$zip->open($source.'/'.$destination, ZIPARCHIVE::CREATE)) {
			return false;
		}
	
		foreach ($files as $diskName=>$name) {
			if (file_exists($source. '/'.$diskName))
				$zip->addFile($source . '/'.$diskName, $name);
		}
		
		/* echo "numfiles: " . $zip->numFiles . "\n";
		echo "status:" . $zip->status . "\n";
		echo $zip->close(); */
		//echo "Ok!";
	
		return $zip->close();
	}
}