<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');
$sessionTimeout = 5; // 5 secondes
// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
		'sourceLanguage'=>'00',
		'language'=>'en',
	//'behaviors' => array('ApplicationConfigBehavior'),
	'name'=>'mRNA Stability Analyzer',

	// preloading 'log' component
	'preload'=>array('log'),

	// autoloading model and component classes
	'import'=>array(
		'application.models.*',
		'application.models.exp.*',
		'application.models.exp.file.*',
		'application.models.exp.op.*',
		'application.models.exp.op.analyse.*',
		'application.models.exp.op.cluster.*',
		'application.models.exp.op.filter.*',
		'application.components.*',		
		'application.components.widgets.fileop.*',				
		'application.controllers.*',
		'application.controllers.exp.*',
		'application.controllers.exp.op.*',
		'application.extensions.fileop.*',
		'application.extensions.phaActiveColumn.*',
	),

	'modules'=>array(
		// uncomment the following to enable the Gii tool
		
		'gii'=>array(
			'class'=>'system.gii.GiiModule',
			'password'=>'andrei',
		 	// If removed, Gii defaults to localhost only. Edit carefully to taste.
			'ipFilters'=>array('127.0.0.1','::1'),
		),
		
	),

	// application components
	'components'=>array(
			// Handling Session			
			'session' => array (	
                        'class' => 'CHttpSession',
                        'timeout' => '5',		
					'autoStart' => 'false',
'cookieMode'=>'only',
					/* 'class'=>'CHttpSession',			
					'useTransparentSessionID'   =>($_POST['PHPSESSID']) ? true : false,			
					'autoStart' => 'true',			
					'cookieMode' => 'allow',					
					'timeout' => 100 */
			
			),
			'request'=>array(
					'enableCookieValidation'=>true,
					//'enableCsrfValidation'=>true,
			),
			'urlManager'=>array(
					'class'=>'application.components.UrlManager',
					'urlFormat'=>'path',
					'showScriptName'=>false,
					'rules'=>array(
							'<language:(en|es)>/' => 'site/index',
							'<language:(en|es)>/<action:(contact|login|logout)>/*' => 'site/<action>',
							'<language:(en|es)>/<controller:\w+>/<id:\d+>'=>'<controller>/view',
							'<language:(en|es)>/<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
							'<language:(en|es)>/<controller:\w+>/<action:\w+>/*'=>'<controller>/<action>',
					),
			),
		'user'=>array(
			// enable cookie-based authentication
			'allowAutoLogin'=>true,
		),
		// uncomment the following to enable URLs in path-format
		
		'urlManager'=>array(
			'urlFormat'=>'path',
			'showScriptName'=>false,
			'rules'=>array(
				'<controller:\w+>/<id:\d+>'=>'<controller>/view',
				'<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
				'<controller:\w+>/<action:\w+>'=>'<controller>/<action>',
			),
				
		), 
			
		/*
		'db'=>array(
			'connectionString' => 'sqlite:'.dirname(__FILE__).'/../data/testdrive.db',
		),*/
		// uncomment the following to use a MySQL database
		
		'db'=>array(
			'connectionString' => 'mysql:host=localhost;dbname=pfc',
			'emulatePrepare' => true,
			'username' => 'pfc',
			'password' => 'pfc',
			'charset' => 'utf8',
  			'tablePrefix' => 'pfc_',
		),
		
		'errorHandler'=>array(
			// use 'site/error' action to display errors
            'errorAction'=>'site/error',
        ),
		'log'=>array(
			'class'=>'CLogRouter',
			'routes'=>array(
				array(
					'class'=>'CFileLogRoute',
					'levels'=>'error, warning',
				),
				// uncomment the following to show log messages on web pages
				/* 
				 array(
					'class'=>'CWebLogRoute',
				),  */
				
			),
		),
	),

	// application-level parameters that can be accessed
	// using Yii::app()->params['paramName']
	'params'=>array(
		// this is used in contact page
		'adminEmail'=>'andrei.alic@gmail.com',//'webmaster@grisplata.uv.es',
		'languages'=>array('en'=>'English', 'es'=>'Espanol'),
			'session_timeout'=> $sessionTimeout
	),
);