<?php
/**
 * Modified class from Yii to allow the site wide operations which are not directly related to experiments
 * @author andrei
 *
 */

class SiteController extends Controller
{
	
	/**
	 * set the application language or the theme according to the choice of the user
	 */
	public function actionChangelanguage()
	{
		if (isset($_POST['language']))
			Yii::app()->user->setState('applicationLanguage',$_POST['language']);
		$this->redirect($_POST['url']);
	}
	
	public function actionHelpd($id) {
		/* $this->renderPartial('/site/help_dialog', array('id' => $id,
				'text'=> Yii::t('lstrings', $id)),
				false,true);
		Yii::app()->end(); */
		/* echo CJSON::encode(array(
				'status'=>'success',
				'div'=>"Books successfully added")); */
		echo Yii::t('lstrings', $id);
	}
	
	/**
	 * Upload a file action 
	 */
	/* public function actionUpload() {
		Yii::import("application.extensions.EAjaxUpload.qqFileUploader");
		// build the path
		if (Yii::app()->user->getIsAuthenticated()) 
			$folder='upload/';// folder for uploaded files
		else 
			$folder='protected/data/unreg/test';// folder for uploaded files
		//set options
		$allowedExtensions = array("txt", "csv", "dat");//array("jpg","jpeg","gif","exe","mov" and etc...
		$sizeLimit = 10 * 1024 * 1024;// maximum file size in bytes
		$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
		$result = $uploader->handleUpload($folder);
		$return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
		
		$fileSize=filesize($folder.$result['filename']);//GETTING FILE SIZE
		$fileName=$result['filename'];//GETTING FILE NAME
		
		echo $return;// it's array
	}
	 */
	/**
	 * Declares class-based actions.
	 */
	public function actions()
	{
		return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
			),
			// page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
			'page'=>array(
				'class'=>'CViewAction',
			),
		);
	}

	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users. 
	 * The register form is located in this place
	 */
	public function actionIndex()
	{
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$modelReg = new RegisterForm();
		
		if(isset($_POST['ajax']) && $_POST['ajax']==='registerForm')
		{
			echo CActiveForm::validate($modelReg);
			Yii::app()->end();
		}
		
		// collect user input data
		if(isset($_POST['RegisterForm']))
		{
			$modelReg->attributes = $_POST['RegisterForm'];
			// validate user input and redirect to the previous page if valid
			if(($msg = $modelReg->validate()) === TRUE) {
				$msg = Yii::t('lstrings', 'SUC_REGISTER');
				//create folder for the user
				if (!file_exists($dir = Yii::app()->basePath."/data/reg/".$modelReg->getName()."/"))
					mkdir($dir);
			}
			$this->render('/site/register', array('msg' => $msg));
			Yii::app()->end();
		}
		$this->render('/site/index', array('modelReg' => $modelReg));
	}

	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionError()
	{
	    if($error=Yii::app()->errorHandler->error)
	    {
	    	if(Yii::app()->request->isAjaxRequest)
	    		echo $error['message'];
	    	else
	        	$this->render('error', $error);
	    }
	}

	/**
	 * Displays the contact page
	 */
	public function actionContact()
	{
		$model=new ContactForm;
		if(isset($_POST['ContactForm']))
		{
			$model->attributes=$_POST['ContactForm'];
			if($model->validate())
			{
				$headers="From: {$model->email}\r\nReply-To: {$model->email}";
				mail(Yii::app()->params['adminEmail'],$model->subject,$model->body,$headers);
				Yii::app()->user->setFlash('contact','Thank you for contacting us. We will respond to you as soon as possible.');
				$this->refresh();
			}
		}
		$this->render('contact',array('model'=>$model));
	}

	public function actionNone()
	{
	
	}
	
	/**
	 * Displays the login page
	 */
	public function actionLogin()
	{
		
		if(isset($_POST['username']) && isset($_POST['password'])) {
			$model = new LoginForm($_POST['username'], $_POST['password']);
			if(isset($_POST['ajax']) && $_POST['ajax'] === 'loginForm')
					{
						echo CActiveForm::validate($model);
						Yii::app()->end();
					}
			if(Yii::app()->request->isAjaxRequest){
 					if(//$model->validate() && 
 							$model->login()) {
						$this->renderPartial('loggedin_comp');
 						//distroy the current experiment from the session
 						Yii::app()->session['currentExperiment'] = NULL;
 						//$this->redirect('/site/');
 						//$this->refresh();
 					} else {
 						//echo 'Error';
 						//unset($_POST);
 						//$this->renderPartial('login_comp');
 						echo Yii::t('lstrings', 'ERR_LOGIN').' '.
 							CHtml::link(Yii::t('lstrings', 'TRY_AGAIN'), '/site');
 					}
				
			}
		}
		//$this->render('/site/index', array('model'=>$model));
		
// 		$model=new LoginForm;

// 		// if it is ajax validation request
// 		if(isset($_POST['ajax']) && $_POST['ajax']==='login-form')
// 		{
// 			echo CActiveForm::validate($model);
// 			Yii::app()->end();
// 		}

// 		// collect user input data
// 		if(isset($_POST['LoginForm']))
// 		{
// 			$model->attributes=$_POST['LoginForm'];
// 			// validate user input and redirect to the previous page if valid
// 			if($model->validate() && $model->login())
// 				$this->redirect(Yii::app()->user->returnUrl);
// 		}
// 		// display the login form
// 		$this->render('login',array('model'=>$model));
	}

	/**
	 * Logs out the current user and redirect to homepage.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout(true);
		$this->redirect(Yii::app()->homeUrl);
	}
	
	public function actionInfo($message) {
		$this->render('/site/information',array('message'=>$message));
	}
}