<?php
/**
 * Deals with the actions related to an experiment
 * @author andrei
 *
 */
class ExperimentController extends Controller
{
	/**
	 * Declares class-based actions.
	 */
	public function actions()
	{
		return array(
				// page action renders "static" pages stored under 'protected/views/exp/pages'
				// They can be accessed via: index.php?r=exp/experiment/page&view=FileName
				'page'=>array(
						'class'=>'CViewAction',
				),
		);
	}
	
	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$this->render('index');
	}

	/**
	 * Action which is triggered by the file uploader to physically execute the upload
	 * on the server
	 */
	public function actionUploadFile() {
		//$folder = 'upload/';// folder for uploaded files
		$allowedExtensions = array('dat', 'txt', 'csv');//array("jpg","jpeg","gif","exe","mov" and etc...
		$sizeLimit = 1 * 1024 * 1024;// maximum file size in bytes
		$uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
		$result = $uploader->handleUpload(
				Yii::app()->basePath.Yii::app()->session['currentExperiment']->path, TRUE);
		
		 //save the current file in the current experiment
		try {
			//set disk name
			$diskName = time().rand();
			rename(Yii::app()->basePath.Yii::app()->session['currentExperiment']->path.$uploader->getUpFileName(), 
					Yii::app()->basePath.Yii::app()->session['currentExperiment']->path.$diskName);
			Yii::app()->session['currentExperiment']->setCurrentOpFile(
				FileItemFactory::createFile(FileItemFactory::FILE_TYPE_DATA, 
						Yii::app()->basePath.Yii::app()->session['currentExperiment']->path, 
						$diskName,
						$uploader->getUpFileName(),
						$uploader->getUpFileSize(),
						Yii::app()->user->isGuest ? -1 :  
							((Yii::app()->session['currentExperiment']->getCurrentOpFile() != NULL && 
									Yii::app()->session['currentExperiment']->getCurrentOpFile()->isVirtual()) ?
							Yii::app()->session['currentExperiment']->getIdFileItem() :	-1),
						true)); 
			//update db if user logged in
			if (!Yii::app()->user->isGuest) {
				Yii::app()->session['currentExperiment']->update();
			}
			//$result = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
		} catch (Exception $ex) {
			//$this->render('/site/error', array('code'=>$ex->getCode(),
			//		'message' => $ex->getMessage()));
			$result = array('success'=>false, 'filename'=>$uploader->getUpFileName(),
					'errMsg' => $ex->getMessage(), 'errCode' => $ex->getCode());
		} 
		/* $result = array('success'=>false, 'filename'=>$uploader->getUpFileName(), 'errMsg' =>'Error msg',
				'errCode' => 10006);  */
		$result = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
		
		//$model = new FileItem;
		/* if(isset($_POST['FileItem']))
		{
			$model->attributes=$_POST['FileItem'];
			$model->file = CUploadedFile::getInstance($model, 'file');
			if($model->save())
			{
				$model->file->saveAs(Yii::app()->session['currentExperiment']->$path."text.dat");
				//Yii::app()->session['currentExperiment']->
				// redirect to success page
			}
		} */
		//$this->renderPartial('/exp/op/file/file_operations', array('model'=>$model));
		echo $result;
		Yii::app()->end();
	}
	
	/**
	 * Download the current file as appears in the file section of the experiment
	 */
	public function actionDownloadFile() {
		if (Yii::app()->session['currentExperiment']->getCurrentOpFile() != NULL) {
			 header("Cache-Control: no-cache"); 
				header("Content-Type: application/text");
				header('Content-Disposition: attachment; filename="'.
				Yii::app()->session['currentExperiment']->getCurrentOpFile()->getName().'"');
			
			readfile(Yii::app()->basePath.
					Yii::app()->session['currentExperiment']->path.
					Yii::app()->session['currentExperiment']->getCurrentOpFile()->getDiskName()); 
			
			Yii::app()->end();
			/* Yii::app()->request->sendFile(Yii::app()->basePath.
					Yii::app()->session['currentExperiment']->path.
					Yii::app()->session['currentExperiment']->getCurrentOpFile()->getName()
					,array(
					'saveName'=>Yii::app()->session['currentExperiment']->getCurrentOpFile()->getName(),
					'mimeType'=>'text/plain',
					'terminate'=>false,
			)); */
		}
	}
	
	/**
	 * Download the clicked operation from the history column
	 * @param int $id The id of the operation, used to get the list of files
	 */
	public function actionDownOpHist($id) {
		$op = Yii::app()->session['currentExperiment']->getOpHistById($id);
		$result = array();
		//echo $op->getResult();
		$files = $op->getResult()->getAllFiles();
		$inputFile = $op->getInput()->getFile();
		
		// create an array containing all diskname=>name pairs
		foreach ($files as $f) 
			$result[$f->getDiskName()] = $f->getDiskName();
		$result[$inputFile->getDiskName()] = $inputFile->getName();
		Util::zip(Yii::app()->basePath.
					Yii::app()->session['currentExperiment']->path, 
				$result,
				$op->getId().'.zip');
		//restore the operation array
		array_pop($files);
		header("Cache-Control: no-cache");		
		header('Content-Type: application/zip');
		header("Content-Disposition: attachment; filename=".$op->getId().'.zip');
		readfile(Yii::app()->basePath.
					Yii::app()->session['currentExperiment']->path.$op->getId().'.zip');
	}
	
	/**
	 * Display the history page with the experiments list
	 */
	public function actionExpHistory() {
		if (Yii::app()->user->isGuest) {//if the user is not logged in the display an info message
			$this->render('/site/information', array('message' => Yii::t('lstrings', 'MSG_EXP_MENU_USER')));
		} else {
			$this->render('/exp/exp_history', array('provider' => Experiment::getAllExperimentsByUser(),
					'expLink' => Experiment::getExpLink()));
	
		}
	}
	
	/**
	 * Show more details about an experiment
	 * @param int $id
	 */
	public function actionExpDetails($id) {
		if (Yii::app()->user->isGuest) {//if the user is not logged in the display an info message
			$this->render('/site/information', array('message' => Yii::t('lstrings', 'MSG_EXP_MENU_USER')));
		} else {
			$model = new Experiment(Yii::t('lstrings', 'EXPERIMENT_MENU'));
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='experimentSetForm')
			{
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			
			// collect user input data
			if(isset($_POST['Experiment']))
			{
				$model->attributes = $_POST['Experiment'];
				// validate user input and redirect to the previous page if valid
				if($model->validate()) {
					//start a new experiment					
					$this->actionStart(str_replace('/', '#', Yii::app()->request->url),
							$model->getTitle(), $model->getDescription());
				}
			} else {//if not submit, render the page for the user 			
				if ($id == '-1') {//if the id is negative then a new experiment will be created
					$this->render('/exp/exp_details', array('model' => $model));
				} else {//if id is positive then search for id and if the user is allowed to access that experiment
					//get usr id to check if the requested exp is belonging to the current user
					$idUser = Yii::app()->user->getId();
				}
			}
		}
	}
	
	/**
	 * Deletes an experiment from the database along with all its operations and files
	 * @param int $id The id of the experiment to be deleted, as taken from the grid view
	 */
 	public function actionDelete($id) {
// 		$criteria = new CDbCriteria();
// 		// 		$criteria->condition = SqlUtil::EXPERIMENT_USER_FK.' = :id';
// 		// 		$criteria->params = array(':id' => Yii::app()->user->getId());
// 		$criteria->compare(SqlUtil::ID_COL, $id, TRUE, 'AND');
		try {
			$model = Experiment::model();
			$keyToDel = $model->findByPk($id);
			if ($keyToDel !== NULL) {
				//select all the operations with a certain id
				/* $dataR = Yii::app()->db->createCommand()->select()
				->from(SqlUtil::OPERATION_TBL)
				->where(array('and', SqlUtil::OPERATION_EXPERIMENT_FK.'='.$keyToDel->getId()))
				->queryAll();
				
				//remove all operations associated with this experiment, it it has any
				if (count($dataR) > 0)
					foreach ($dataR as $o) {
						$op = new Operation();
						$op->setId($o[SqlUtil::ID_COL]);
						$op->deleteOperation($o[SqlUtil::ID_COL]);
					} */
				//get the ids of all files related to this experiment
				$fileIdsRes = Yii::app()->db->createCommand()->select('res.'.SqlUtil::RESULT_FILEITEM_FK)
				->from(SqlUtil::OPERATION_TBL.' op')
				->join(SqlUtil::EXPERIMENT_TBL.' exp',
						'op.'.SqlUtil::OPERATION_EXPERIMENT_FK.' = exp.'.SqlUtil::ID_COL)
						->join(SqlUtil::RESULT_TBL.' res',
								'op.'.SqlUtil::ID_COL.' = res.'.SqlUtil::RESULT_OPERATION_FK)
								->where(array('and', 'exp.'.SqlUtil::ID_COL.'='.$keyToDel->getId()))
								->queryAll();
				
				$fileIdsResClu = Yii::app()->db->createCommand()->select('res.'.
						SqlUtil::RESULTCLUSTER_FILEITEM_FILEDATA_FK.', res.'.
						SqlUtil::RESULTCLUSTER_FILEITEM_FILECLUSTER_FK)
						->from(SqlUtil::OPERATION_TBL.' op')
						->join(SqlUtil::EXPERIMENT_TBL.' exp',
								'op.'.SqlUtil::OPERATION_EXPERIMENT_FK.' = exp.'.SqlUtil::ID_COL)
								->join(SqlUtil::RESULTCLUSTER_TBL.' res',
										'op.'.SqlUtil::ID_COL.' = res.'.SqlUtil::RESULTCLUSTER_RESULT_FK)
										->where(array('and', 'exp.'.SqlUtil::ID_COL.'='.$keyToDel->getId()))
										->queryAll();
				
				$fileIdsInp = Yii::app()->db->createCommand()->select('inp.'.
						SqlUtil::INPUT_FILEITEM_FK)
						->from(SqlUtil::OPERATION_TBL.' op')
						->join(SqlUtil::EXPERIMENT_TBL.' exp',
								'op.'.SqlUtil::OPERATION_EXPERIMENT_FK.' = exp.'.SqlUtil::ID_COL)
								->join(SqlUtil::INPUT_TBL.' inp',
										'op.'.SqlUtil::ID_COL.' = inp.'.SqlUtil::INPUT_OPERATION_FK)
										->where(array('and', 'exp.'.SqlUtil::ID_COL.'='.$keyToDel->getId()))
										->queryAll();
				
				//cascade delete
				$keyToDel->delete();
				
				//delete current op file item if set
				if (($idF = $keyToDel->getIdFileItem()) != Util::ID_UNDEFINED)
					FileItemFactory::deleteFileDb($idF);
				
				//delete files from result
				foreach ($fileIdsRes as $row) {
					FileItemFactory::deleteFileDb($row[SqlUtil::RESULT_FILEITEM_FK]);
				}
				
				
				
				//delete files from result cluster
				foreach ($fileIdsResClu as $row) {
					FileItemFactory::deleteFileDb($row[SqlUtil::RESULTCLUSTER_FILEITEM_FILEDATA_FK]);
					FileItemFactory::deleteFileDb($row[SqlUtil::RESULTCLUSTER_FILEITEM_FILECLUSTER_FK]);
				}
				
				
				//delete files from result cluster
				foreach ($fileIdsInp as $row) {
					FileItemFactory::deleteFileDb($row[SqlUtil::INPUT_FILEITEM_FK]);
				}
				
				
				//remove files and folders from disk
				if (file_exists(Yii::app()->basePath.$keyToDel->getPath())) 
					Util::recRmdir(Yii::app()->basePath.$keyToDel->getPath());
				//$keyToDel->setId($id);
				//$result = $keyToDel->delete();
				//remove from session if necessary
				if (Yii::app()->session['currentExperiment'] != NULL &&
						Yii::app()->session['currentExperiment']->getId() == $keyToDel->getId()) {
					Yii::app()->session['oldFormVals'] = NULL;
					Yii::app()->session['currentExperiment'] = NULL;
				}
				
			}
			$this->actionExpHistory();
		} catch(Exception $e) {
			//display the errors and finish the execution for yii
			$this->render('/site/error', array('code' => $e->getCode(),
					'message' => $e->getMessage()));
			Yii::app()->end();
		}
		//echo $result;
	}
	
	/**
	 * Set the experiment identified by its id as current
	 * @param int $id The id of the experiment which must be set as current
	 */
	public function actionSetCurrent($id) {
		if (($idI = intval($id)) > Util::ID_UNDEFINED) {
			try {
				$model = Experiment::model();
				$experiment = $model->findByPk($id);
				if ($experiment !== NULL) {
					//remove current experiment
					Yii::app()->session['currentExperiment'] = NULL;
					//load the operations
					$experiment->setOperationHistory(Operation::loadOperations($id));
					//load current experiment file item
					$experiment->setCurrentOpFile(FileItemFactory::createFileDb($experiment->getIdFileItem()));
					//set as current experiment
					Yii::app()->session['oldFormVals'] = array();
					Yii::app()->session['currentExperiment'] = $experiment;
				}
				$this->actionExpHistory();
			} catch(Exception $e) {
				//display the errors and finish the execution for yii
				$this->render('/site/error', array('code' => $e->getCode(),
						'message' => $e->getMessage()));
				Yii::app()->end();
			}
		}
	}
	
	/**
	 * start a new experiment and define the paths for it
	 */
	public function actionStart($initialUrl, $eTitle = NULL, $eDesc = NULL) {
		//create a session object
		/* $session=new CHttpSession;
		$session->open(); */
		$session = Yii::app()->getSession();
		//$session->sessionID = $PHPSESSID;
		$session->open();
		Yii::app()->session['start'] = time();
		//get experiment time in miliseconds
		$time = time();//round(microtime(true) * 1000);
		$expName = $time.rand();
		//if the session user is null then the experiment will be saved in a temp folder
		if (Yii::app()->user->isGuest) {
			$path = "/data/unreg/".$expName."/";
			mkdir(Yii::app()->basePath.$path);
			$experiment = new Experiment(Yii::t('lstrings', 'ANON_EXPERIMENT'),
				$time, NULL, $path);
		} else {
			$path = "/data/reg/".Yii::app()->user->getName()."/".$expName."/";
			mkdir(Yii::app()->basePath.$path);
 			/* $fileItem = FileItemFactory::createFileVirtual();
 			$fileItem->setIsNewRecord(true);		 */	
			try {
// 				$fileItem = FileItemFactory::model();
// 				$fileItem->setIsNewRecord(true);
				//$fileItem->insert(array());
 				//$res =  $fileItem->save();
				$experiment = new Experiment($eTitle, $time, $eDesc, $path, Yii::app()->user->getId(),
						NULL, NULL);//$fileItem, $fileItem->getId());
				//$experiment->setCurrentOpFile($fileItem);
				$experiment->setIsNewRecord(true);
				//save the exp in the db
				$experiment->save();
			} catch (Exception $ex) {
				//display the errors and finish the execution for yii
				$this->render('/site/error', array('code' => $ex->getCode(),
						'message' => $ex->getMessage()));
				Yii::app()->end();				
			}
		}
		
		//Operation::clearOldValues(Yii::app()->session['currentExperiment']);
		Yii::app()->session['currentExperiment'] = $experiment;
		Yii::app()->session['oldFormVals'] = array();
		$this->redirect(str_replace('#', '/', $initialUrl));
	}


	/**
	 * Get the description of a certain experiment by id; The id is sent using get from the HTML table
	 * @param id $id the ID in the database for the selected experiment
	 */
	public function actionViewDescription($id) {
		if (($idI = intval($id)) > Util::ID_UNDEFINED) {
			$model = Experiment::model();
			$experiment = $model->findByPk($id);
			if ($experiment !== NULL) {
				echo $experiment->getDescription();
			}
		}
	}
	
}