<?php
/**
 * All methods to analyse an input using a C program; These are called
 * directly from the browser
 * @author andrei
 *
 */
class AnalyseController extends OperationController
{

	/**
	 * Execute operations associated with the genarray implementation of the algorithms
	 */
	public function actionGenarray() {
		Yii::app()->session['allowPgAjaxRef'] = true;		
		if (!isset(Yii::app()->session['currentExperiment'])) {
			parent::showCreateExp();
			//$this->render('/exp/op/anon_operation');
		} else {
			$this->layout='//layouts/operation';
			//parent::actionUploadFile();
			$model = new GenarrayForm(Operation::OP_ANALYSE, Operation::ALGO_GENARRAY,
					time(), new InputAnalyse(),
					new ResultAnalyse(),
					Yii::t('lstrings', 'GENARRAY_SMENU'));
				
			if (Yii::app()->session['currentExperiment']->getCurrentOpFile() === NULL) {
				$this->render('/exp/op/no_input', array('model'=>$model));
			} else if (Yii::app()->session['currentExperiment']->getCurrentOpFile()->hasTRRA()
					&& Yii::app()->session['currentExperiment']->getCurrentOpFile()->hasTR()
					&& Yii::app()->session['currentExperiment']->getCurrentOpFile()->hasRA()) {
			
				// if it is ajax validation request
				if(isset($_POST['ajax']) && $_POST['ajax'] === 'analyseSetForm')
				{
					echo CActiveForm::validate($model);
					Yii::app()->end();
				}
					
				// collect user input data
				if(isset($_POST['GenarrayForm']))
				{
				Yii::app()->session['allowPgAjaxRef'] = false;
					$model->attributes = $_POST['GenarrayForm'];
					// validate user input and redirect to the previous page if valid
					if($model->validate()) {
						//save the model because the user submited it
						$array = Yii::app()->session['oldFormVals'];
						$array[$model->getAlgoName()] = $model;
						Yii::app()->session['oldFormVals'] = $array;
						//save/restore the custom values set by the user
							
						$model->getInput()->setFile(Yii::app()->session['currentExperiment']->getCurrentOpFile());
						$model->runMethod();
						Yii::app()->session['currentExperiment']->addOperationHistory($model);
						//$this->redirect('/exp/op/cluster/result');
						//$model = Yii::app()->session['currentExperiment']->getLastOperation();
						/* //save values in the db
						if (!Yii::app()->user->isGuest) {
							$model->saveOperation();
						} */
						
						$this->render('/exp/op/analyse/analyse_result', array('model'=>$model));
						Yii::app()->end(0);
					}
				} else {//if not submiting the values
					//save/restore the custom values set by the user
					if (isset(Yii::app()->session['oldFormVals'][$model->getAlgoName()]))
						$model->loadOldValues(Yii::app()->session['oldFormVals'][$model->getAlgoName()]);
				}
				// display the login form
				$this->render('/exp/op/analyse/analyse_settings', array('model'=>$model));
			} else {
				$this->render('/exp/op/analyse/analyse_in_probl', array('model'=>$model));
			
			}
		}
	}
	
	/**
	 * Execute Stabilogen operations
	 */
	public function actionStabilogen() {
		Yii::app()->session['allowPgAjaxRef'] = true;
		if (!isset(Yii::app()->session['currentExperiment'])) {
			parent::showCreateExp();
		} else  {
			$this->layout='//layouts/operation';
			//parent::actionUploadFile();
			$model = new StabilogenForm(Operation::OP_ANALYSE, Operation::ALGO_STABILOGEN, 
					time(), new InputAnalyse(),
					new ResultAnalyse(),
					Yii::t('lstrings', 'STABILOGEN_SMENU'));
			
			if (Yii::app()->session['currentExperiment']->getCurrentOpFile() === NULL) {
				$this->render('/exp/op/no_input', array('model'=>$model));
			} else if (Yii::app()->session['currentExperiment']->getCurrentOpFile()->hasTRRA()
					&& Yii::app()->session['currentExperiment']->getCurrentOpFile()->hasTR()
					&& Yii::app()->session['currentExperiment']->getCurrentOpFile()->hasRA()) {
				
				// if it is ajax validation request
				if(isset($_POST['ajax']) && $_POST['ajax'] === $model->getFormId())
				{
					echo CActiveForm::validate($model);
					Yii::app()->end();
				}
					
				// collect user input data
				if(isset($_POST[get_class($model)]))
				{
				Yii::app()->session['allowPgAjaxRef'] = false;
					$model->attributes = $_POST[get_class($model)];
					// validate user input and redirect to the previous page if valid
					if($model->validate()) {
						//save the model because the user submited it
						$array = Yii::app()->session['oldFormVals'];
						$array[$model->getAlgoName()] = $model;
						Yii::app()->session['oldFormVals'] = $array;
						$model->getInput()->setFile(Yii::app()->session['currentExperiment']->getCurrentOpFile());
						$model->runMethod();
						Yii::app()->session['currentExperiment']->addOperationHistory($model);
						//$this->redirect('/exp/op/cluster/result');
						//$model = Yii::app()->session['currentExperiment']->getLastOperation();
						$this->render('/exp/op/analyse/analyse_result', array('model'=>$model));
						Yii::app()->end(0);
					}
				} else {//if not submiting the values
					//save/restore the custom values set by the user
					if (isset(Yii::app()->session['oldFormVals'][$model->getAlgoName()]))
						$model->loadOldValues(Yii::app()->session['oldFormVals'][$model->getAlgoName()]);
				}
				// display the login form
				$this->render('/exp/op/analyse/analyse_settings', array('model'=>$model));
			} else {
				$this->render('/exp/op/analyse/analyse_in_probl', array('model'=>$model));
				
			}
		}
	}
	
	/**
	 * Execute Stabilogen operations
	 */
	public function actionShutoff() {
		Yii::app()->session['allowPgAjaxRef'] = true;
		if (!isset(Yii::app()->session['currentExperiment'])) {
			parent::showCreateExp();
		} else  {
			$this->layout='//layouts/operation';
			//parent::actionUploadFile();
			$model = new ShutoffForm(Operation::OP_ANALYSE, Operation::ALGO_SHUTOFF,
					time(), new InputAnalyse(),
					new ResultAnalyse(),
					Yii::t('lstrings', 'SHUTOFF_SMENU'));
				
			if (Yii::app()->session['currentExperiment']->getCurrentOpFile() === NULL) {
				$this->render('/exp/op/no_input', array('model'=>$model));
			} else {
	
				// if it is ajax validation request
				if(isset($_POST['ajax']) && $_POST['ajax'] === $model->getFormId())
				{
					echo CActiveForm::validate($model);
					Yii::app()->end();
				}
					
				// collect user input data
				if(isset($_POST[get_class($model)]))
				{
					Yii::app()->session['allowPgAjaxRef'] = false;
					$model->attributes = $_POST[get_class($model)];
					// validate user input and redirect to the previous page if valid
					if($model->validate()) {
						//save the model because the user submited it
						$array = Yii::app()->session['oldFormVals'];
						$array[$model->getAlgoName()] = $model;
						Yii::app()->session['oldFormVals'] = $array;
						$model->getInput()->setFile(Yii::app()->session['currentExperiment']->getCurrentOpFile());
						$model->runMethod();
						Yii::app()->session['currentExperiment']->addOperationHistory($model);
						//$this->redirect('/exp/op/cluster/result');
						//$model = Yii::app()->session['currentExperiment']->getLastOperation();
						$this->render('/exp/op/analyse/analyse_result', array('model'=>$model));
						Yii::app()->end(0);
					}
				} else {//if not submiting the values
					//save/restore the custom values set by the user
					if (isset(Yii::app()->session['oldFormVals'][$model->getAlgoName()]))
						$model->loadOldValues(Yii::app()->session['oldFormVals'][$model->getAlgoName()]);
				}
				// display the login form
				$this->render('/exp/op/analyse/shutoff_settings', array('model'=>$model));
			}
		}
	}
	

}