<?php
/**
 * All methods to cluster the input using R scripts and then
 * to display the results to the user
 * @author andrei
 *
 */
class ClusterController extends OperationController
{

	/**
	 * Declares class-based actions.
	 */
	
	
	/* public function actionClustering() {
		$model=new UpgmaForm;
		$formName = NULL;
		// if it is ajax validation request
		if(isset($_POST['ajax']) && 
				($_POST['ajax']==='UpgmaForm' ||
					$_POST['ajax']==='KmeansForm' ||
					$_POST['ajax']==='SotaForm'
						))
		{
			$formName = $_POST['ajax'];
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		
		// collect user input data
		if(isset($_POST[$formName]))
		{
			$model->attributes=$_POST[$formName];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->runUpgma())
				$this->redirect(Yii::app()->user->returnUrl);
		}
		if ($formName != NULL)
			// display the login form
		$this->render('/operation/cluster/'.strtolower($formName).'_settings', array('model'=>$model));
	} */
	
	/* public function actionDownnewick() {
		if (($op = Yii::app()->session['currentExperiment']->getLastOperation()->isOpClustering())) {
			$file = $op->getResult()->getFileNewick();
			header("Cache-Control: no-cache");
			header("Content-Type: application/text");
			header('Content-Disposition: attachment; filename="'.
					$file->getName().'"');
				
			readfile(Yii::app()->basePath.
					Yii::app()->session['currentExperiment']->path.
					$file->getDiskName());
				
			Yii::app()->end();
		} else {
			$this->render('/site/error', array('message'=>Yii::t('lstrings', 'ERR_FILE_NOT_FOUND')));
		}
	} */
	
	/**
	 * Action called from the cluster result page to obtain a file with the description of each cluster
	 * generated by the last run algorithm
	 */
	public function actionDowncluster() {
		$op = Yii::app()->session['currentExperiment']->getLastOperation();
		if ($op->isOpClustering() && $op->hasResultFileCluster()) {
			$this->downFile($op->getResult()->getFileCluster());
			/* $file = $op->getResult()->getFileCluster();
			header("Cache-Control: no-cache");
			header("Content-Type: application/text");
			header('Content-Disposition: attachment; filename="'.
					$file->getName().'"');
			
			readfile(Yii::app()->basePath.
					Yii::app()->session['currentExperiment']->path.
					$file->getDiskName());
		
			Yii::app()->end(); */
		} else {
			$this->render('/site/error', array('message'=>Yii::t('lstrings', 'ERR_FILE_NOT_FOUND')));
		}
	}
	
	/**
	 * Anonymously download the clustering result image and hide the real path. Just provide the byte stream to the browser
	 */
	public function actionGetClusterImg() {
		if (isset(Yii::app()->session['currentExperiment']) &&
				($lop = Yii::app()->session['currentExperiment']->getLastOperation()) !== NULL &&
				Yii::app()->session['currentExperiment']->getLastOperation()->isOpClustering()) {
			
			$filePath = Yii::app()->basePath.Yii::app()->session['currentExperiment']->path.
				$lop->getResult()->getFile()->getDiskName();
			// get the filename extension
			$ext = substr($filePath, -3);
			// set the MIME type
			switch ($ext) {
				case 'jpg':
					$mime = 'image/jpeg';
					break;
				case 'gif':
					$mime = 'image/gif';
					break;
				case 'png':
					$mime = 'image/png';
					break;
				case 'svg':
					$mime = 'image/svg+xml';
					break;
				default:
					$mime = false;
			}
			// if a valid MIME type exists, display the image
			// by sending appropriate headers and streaming the file
			if ($mime) {
				header('Content-type: '.$mime);
				header('Content-length: '.filesize($filePath));
				$file = @ fopen($filePath, 'rb');
				if ($file) {
					fpassthru($file);
					Yii::app()->end();
				}
			}
		}
	}
	
	/**
	 * Renders a specific page with settings for UPGMA algorithm.
	 * These settings are used afterwards to execute the R scripts.
	 * (non-PHPdoc)
	 * @see ExperimentController::actionUpgma()
	 */
	public function actionUpgma() {
		Yii::app()->session['allowPgAjaxRef'] = true;
		 if (!isset(Yii::app()->session['currentExperiment'])) {
			parent::showCreateExp();
		} else  { 
			$this->layout='//layouts/operation';
			//check if a file was uploaded; if not do not show the settings
			
			//parent::actionUploadFile();
			$model = new UpgmaForm( Operation::OP_CLUSTER, Operation::ALGO_UPGMA,
					time(), new InputCluster(),
					new ResultCluster(),
					Yii::t('lstrings', 'UPGMA_SMENU'));
			if (Yii::app()->session['currentExperiment']->getCurrentOpFile() === NULL) {
				$this->render('/exp/op/no_input', array('model'=>$model));
			} else {
				// if it is ajax validation request
				if(isset($_POST['ajax']) && $_POST['ajax']==='upgmaSetForm')
				{
					echo CActiveForm::validate($model);
					Yii::app()->end();
				}
				
				// collect user input data
				if(isset($_POST['UpgmaForm']))
				{
				Yii::app()->session['allowPgAjaxRef'] = false;
					$model->attributes = $_POST['UpgmaForm'];
					// validate user input and redirect to the previous page if valid
					if($model->validate()) {
						//save the model because the user submited it
						$array = Yii::app()->session['oldFormVals'];
						$array[$model->getAlgoName()] = $model;
						Yii::app()->session['oldFormVals'] = $array;
						$model->getInput()->setFile(Yii::app()->session['currentExperiment']->getCurrentOpFile());
						$model->runMethod();
						//$this->redirect('/exp/op/cluster/result');
						//$model = Yii::app()->session['currentExperiment']->getLastOperation();
						$this->render('/exp/op/cluster/cluster_result', array('model'=>$model));
						Yii::app()->end(0);
					}
				} else {//if not submiting the values
					//save/restore the custom values set by the user
					if (isset(Yii::app()->session['oldFormVals'][$model->getAlgoName()]))
						$model->loadOldValues(Yii::app()->session['oldFormVals'][$model->getAlgoName()]);						
				}
				// display the login form				
				$this->render('/exp/op/cluster/upgma_settings', array('model'=>$model));
			}
		}
	}
	
	/**
	 * Renders a specific page with settings for Kmeans algorithm.
	 * These settings are used afterwards to execute the R scripts.
	 * (non-PHPdoc)
	 * @see ExperimentController::actionUpgma()
	 */
	public function actionKmeans() {
		Yii::app()->session['allowPgAjaxRef'] = true;
		if (Yii::app()->session['currentExperiment'] === NULL) {
			parent::showCreateExp();
		} else  {
			$this->layout='//layouts/operation';
			$model = new KmeansForm(Operation::OP_CLUSTER, Operation::ALGO_KMEANS,
					time(), new InputCluster(),
					new ResultCluster(),
					Yii::t('lstrings', 'KMEANS_SMENU'));
			if (Yii::app()->session['currentExperiment']->getCurrentOpFile() === NULL) {
				$this->render('/exp/op/no_input', array('model'=>$model));
			} else {
				$model->getInput()->setFile(Yii::app()->session['currentExperiment']->getCurrentOpFile());
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='kmeansSetForm')
			{
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			
			// collect user input data
			if(isset($_POST['KmeansForm']))
			{
				Yii::app()->session['allowPgAjaxRef'] = false;
				$model->attributes = $_POST['KmeansForm'];
				//see if the user sent the legitimate data to you 
				 /* if (isset($_POST['KmeansForm']['centers']) && 
						!isset($_POST['KmeansForm']['clusters'])
						&& !isset($_POST['KmeansForm']['numRandSets']))  
					$scenario = 'centers';
				 else if (!isset($_POST['KmeansForm']['centers']) && 
						isset($_POST['KmeansForm']['clusters'])
						&& isset($_POST['KmeansForm']['numRandSets']))
					$scenario = 'clusters';   */
				// validate user input and redirect to the previous page if valid
				if(//isset($scenario) && 
						$model->validate()) {
					//save the model because the user submited it
					$array = Yii::app()->session['oldFormVals'];
						$array[$model->getAlgoName()] = $model;
						Yii::app()->session['oldFormVals'] = $array;
					
					$model->getInput()->setFile(Yii::app()->session['currentExperiment']->getCurrentOpFile());
					$model->runMethod();
					//$this->redirect('/exp/op/cluster/result');
					//$model = Yii::app()->session['currentExperiment']->getLastOperation();
					$this->render('/exp/op/cluster/cluster_result', array('model'=>$model));
					Yii::app()->end(0);
				}
			} else {//if not submiting the values
					//save/restore the custom values set by the user
					if (isset(Yii::app()->session['oldFormVals'][$model->getAlgoName()]))
						$model->loadOldValues(Yii::app()->session['oldFormVals'][$model->getAlgoName()]);						
				}
			// display the login form
			$this->render('/exp/op/cluster/kmeans_settings', array('model'=>$model));
			}
		}
	}
	
	/**
	 * Renders a specific page with settings for Sota algorithm.
	 * These settings are used afterwards to execute the R scripts.
	 * (non-PHPdoc)
	 * @see ExperimentController::actionUpgma()
	 */
	public function actionSota() {
		Yii::app()->session['allowPgAjaxRef'] = true;
		if (Yii::app()->session['currentExperiment'] === NULL) {
			parent::showCreateExp();
		} else  {
		$this->layout='//layouts/operation';
			$model=new SotaForm(Operation::OP_CLUSTER, Operation::ALGO_SOTA,
					time(), new InputCluster(),
					new ResultCluster(),
					Yii::t('lstrings', 'SOTA_SMENU'));
			if (Yii::app()->session['currentExperiment']->getCurrentOpFile() === NULL) {
				$this->render('/exp/op/no_input', array('model'=>$model));
			} else {
			// if it is ajax validation request
			if(isset($_POST['ajax']) && $_POST['ajax']==='sotaSetForm')
			{
				echo CActiveForm::validate($model);
				Yii::app()->end();
			}
			
			// collect user input data
			if(isset($_POST['SotaForm']))
			{
				
				Yii::app()->session['allowPgAjaxRef'] = false;
				$model->attributes=$_POST['SotaForm'];
				// validate user input and redirect to the previous page if valid
				if($model->validate()) {
					//save the model because the user submited it
					$array = Yii::app()->session['oldFormVals'];
						$array[$model->getAlgoName()] = $model;
						Yii::app()->session['oldFormVals'] = $array;
					$model->getInput()->setFile(Yii::app()->session['currentExperiment']->getCurrentOpFile());
					$model->runMethod();
					//$this->redirect('/exp/op/cluster/result');
					//$model = Yii::app()->session['currentExperiment']->getLastOperation();
					$this->render('/exp/op/cluster/cluster_result', array('model'=>$model));
					Yii::app()->end(0);
				}
			} else {//if not submiting the values
					//save/restore the custom values set by the user
					if (isset(Yii::app()->session['oldFormVals'][$model->getAlgoName()]))
						$model->loadOldValues(Yii::app()->session['oldFormVals'][$model->getAlgoName()]);						
				}
			// display the login form
			$this->render('/exp/op/cluster/sota_settings', array('model'=>$model));
			}
		}
	}
	
	/**
	 * Show the result to the user depending of the type of the used algorithm
	 */
	public function actionResult() {
		Yii::app()->session['allowPgAjaxRef'] = false;
		$this->layout='//layouts/operation';
		$model = Yii::app()->session['currentExperiment']->getLastOperation();
		$this->render('/exp/op/cluster/cluster_result', array('model'=>$model));
	}

}