<?php
/**
 * The class which responds to request for any filter method implemented
 * @author andrei
 *
 */
class FilterController extends OperationController
{

	public function actionIndex() {
		$this->render('site/pages/future_impl');
	}
	
	/**
	 * Execute the filter NA action by calling the working mechanism implemented in the model to perform
	 * the real filtering
	 */
	public function actionFilterNA() {
		Yii::app()->session['allowPgAjaxRef'] = true;
		if (Yii::app()->session['currentExperiment'] === NULL) {
			parent::showCreateExp();
		} else  {
			$this->layout='//layouts/operation';
			$model = new FilterNAForm(Operation::OP_FILTER, Operation::ALGO_FILTER_NA,
					time(), new InputFilter(),
					new ResultFilter(),
					Yii::t('lstrings', 'FILTER_NA_SMENU'));
			if (Yii::app()->session['currentExperiment']->getCurrentOpFile() === NULL) {
				$this->render('/exp/op/no_input', array('model'=>$model));
			} else {
				$model->getInput()->setFile(Yii::app()->session['currentExperiment']->getCurrentOpFile());
				// if it is ajax validation request
				if(isset($_POST['ajax']) && $_POST['ajax']==='filterNASetForm')
				{
					echo CActiveForm::validate($model);
					Yii::app()->end();
				}
					
				// collect user input data
				if(isset($_POST['FilterNAForm']))
				{
					
					Yii::app()->session['allowPgAjaxRef'] = false;
					$model->attributes = $_POST['FilterNAForm'];
					//see if the user sent the legitimate data to you
					/* if (isset($_POST['KmeansForm']['centers']) &&
					 !isset($_POST['KmeansForm']['clusters'])
							&& !isset($_POST['KmeansForm']['numRandSets']))
						$scenario = 'centers';
					else if (!isset($_POST['KmeansForm']['centers']) &&
							isset($_POST['KmeansForm']['clusters'])
							&& isset($_POST['KmeansForm']['numRandSets']))
						$scenario = 'clusters';   */
					// validate user input and redirect to the previous page if valid
					if(//isset($scenario) &&
					$model->validate()) {
						//save the model because the user submited it
						$array = Yii::app()->session['oldFormVals'];
						$array[$model->getAlgoName()] = $model;
						Yii::app()->session['oldFormVals'] = $array;
					//$model->getInput()->setFile(Yii::app()->session['currentExperiment']->getCurrentOpFile());
					$model->runMethod();
					//$this->redirect('/exp/op/cluster/result');
					//$model = Yii::app()->session['currentExperiment']->getLastOperation();
					
					
					$this->render('/exp/op/filter/filter_result', array('model'=>$model));
					Yii::app()->end(0);
					}
					} else {//if not submiting the values
						//save/restore the custom values set by the user
						if (isset(Yii::app()->session['oldFormVals'][$model->getAlgoName()]))
							$model->loadOldValues(Yii::app()->session['oldFormVals'][$model->getAlgoName()]);						
					}
					// display the login form
					$this->render('/exp/op/filter/filter_na_settings', array('model'=>$model));
				}
			}
	}

}