<?php
/**
 * Super class for all operations available for a user 
 * @author andrei
 *
 */
class OperationController extends Controller
{

	/**
	 * Displays the page necessary to create a new experiment if the user tried to execute an operation
	 * before he/she defined an experiment on the session 
	 */
	protected function showCreateExp() {
		if (Yii::app()->user->isGuest)
			$this->render('/exp/op/anon_operation');
		else {
			$this->redirect(Yii::app()->controller->createUrl("exp/experiment/expDetails",
					array('id'=>-1)));
		}
	}
	
	/**
	 * Executes the stream reading and provides the bytes which compose the file on the disk
	 * @param FileItem $file the file to be downloaded
	 */
	public function downFile($file) {
		header("Cache-Control: no-cache");
		header("Content-Type: application/text");
		header('Content-Disposition: attachment; filename="'.
				$file->getName().'"');
	
		readfile(Yii::app()->basePath.
				Yii::app()->session['currentExperiment']->path.
				$file->getDiskName());
		Yii::app()->end();
	}
	
	/**
	 * Method used to anonymously download a certain file from the disk, hidding the real path
	 */
	public function actionDownresult() {
		$op = Yii::app()->session['currentExperiment']->getLastOperation();
		if ($op->isOpClustering()) {
			$this->downFile($op->getResult()->getFileData());
			/* $file = $op->getResult()->getFileData();
				header("Cache-Control: no-cache");
			header("Content-Type: application/text");
			header('Content-Disposition: attachment; filename="'.
					$file->getName().'"');
				
			readfile(Yii::app()->basePath.
					Yii::app()->session['currentExperiment']->path.
					$file->getDiskName());
			Yii::app()->end(); */
		} else if ($op->isOpAnalyse()) {
			$this->downFile($op->getResult()->getFile());
		} else {
			$this->render('/site/error', array('message'=>Yii::t('lstrings', 'ERR_FILE_NOT_FOUND')));
		}
	}
	
}