<?php

class CArrayValidator extends CValidator {
	/** @var int Min length; Greater or equal values are okay */
	public $lMin;
	/** @var int Max length; Less or equal values are okay */
	public $lMax;
	
	/**
	 * Validates the attribute of the object.
	 * If there is any error, the error message is added to the object.
	 * @param CModel $object the object being validated
	 * @param string $attribute the attribute being validated
	 */
	protected function validateAttribute($object, $attribute)
	{
		// extract the attribute value from it's model object
		$value=$object->$attribute;
		if (!is_array($value))
			$this->addError($object, $attribute, Yii::t('lstrings', 'ERR_CARRAYVALIDATOR_NOTARR'));
		if (isset($this->lMin) && $this->lMin > count($value)) {	
			$this->addError($object,$attribute, Yii::t('lstrings', 'ERR_CARRAYVALIDATOR_LENMIN'));
		}
		
		if (isset($this->lMax) && $this->lMax < count($value)) {
			$this->addError($object, $attribute, Yii::t('lstrings', 'ERR_CARRAYVALIDATOR_LENMAX'));
		}
	}
	
	
}