<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'SiteController'.
 */
class LoginForm extends CActiveRecord
{
	public $id;
	public $username;
	public $password;
	public $error = NULL;
	//public $rememberMe;

	private $_identity;

	
	public function __construct($username, $password, $id = Util::ID_UNDEFINED, $error = NULL) {
		$this->username = $username;
		$this->password = $password;
		$this->id = $id;
		$this->error = $error;
		
	}
	
	public function relations()
	{
		return array(
				'experiments'=>array(self::HAS_MANY, 'Experiment',
						SqlUtil::EXPERIMENT_USER_FK)
		);
	}
	
	/**
	 * Declares the validation rules.
	 * The rules state that username and password are required,
	 * and password needs to be authenticated.
	 */
	public function rules()
	{
		return array(
			// username and password are required
			array('username, password', 'required'),
			array('username', 'length', 'min' => 4, 'max' => 25, 'allowEmpty' => FALSE, 
						'tooLong' => Yii::t('lstrings', 'ERR_REG_UN_TOO_LONG'),
								'tooShort' => Yii::t('lstrings', 'ERR_REG_UN_TOO_SHORT')),
			array('password', 'length', 'min' => 4, 'max' => 15, 'allowEmpty' => FALSE, 
						'tooLong' => Yii::t('lstrings', 'ERR_REG_PASS_TOO_LONG'),
								'tooShort' => Yii::t('lstrings', 'ERR_REG_PASS_TOO_SHORT'))
		);
	}

	/**
	 * Declares attribute labels.
	 */
// 	public function attributeLabels()
// 	{
// 		return array(
// 			'rememberMe'=>'Remember me next time',
// 		);
// 	}

	/**
	 * Authenticates the password.
	 * This is the 'authenticate' validator as declared in rules().
	 */
	public function authenticate($attribute,$params)
	{
		if(!$this->hasErrors())
		{
			$this->_identity=new UserIdentity($this->username, $this->password);
			if(!$this->_identity->authenticate())
				$this->addError('password', 'Incorrect username or password.');
		}
	}

	/**
	 * Logs in the user using the given username and password in the model.
	 * @return boolean whether login is successful
	 */
	public function login()
	{
		if($this->_identity===null)
		{
			$this->_identity=new UserIdentity($this->username,$this->password);
			$this->_identity->authenticate();
		}
		if($this->_identity->errorCode===UserIdentity::ERROR_NONE)
		{
			//create session
			$session = Yii::app()->getSession();
			//$session->sessionID = $PHPSESSID;
			$session->open();
			Yii::app()->session['start'] = time();
// 			$duration=$this->rememberMe ? 3600*24*30 : 0; // 30 days
			Yii::app()->user->login($this->_identity, 0);
			return true;
		}
		else
			return false;
	}
	
	public function setError($value) {
		$this->error = $values;
	}
	
	public function getError() {
		return $this->error;
	}
	
}
