<?php

/**
 * Background class to hold the registration data for the HTML form
 * @author andrei
 *
 */
class RegisterForm extends CFormModel//extends CActiveRecord
{
	
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public function tableName()
	{
		return 'experiment';
	}
	
	/**
	 * Declares the validation rules.
	 * The rules state that username and password are required,
	 * and password needs to be authenticated.
	 */
	public function rules()
	{
		return array(
				// username and password are required
				array('username, password', 'required'),
				array('username', 'length', 'min' => 4, 'max' => 25, 'allowEmpty' => FALSE, 
						'tooLong' => Yii::t('lstrings', 'ERR_REG_UN_TOO_LONG'),
								'tooShort' => Yii::t('lstrings', 'ERR_REG_UN_TOO_SHORT')),
				array('password', 'length', 'min' => 4, 'max' => 15, 'allowEmpty' => FALSE, 
						'tooLong' => Yii::t('lstrings', 'ERR_REG_PASS_TOO_LONG'),
								'tooShort' => Yii::t('lstrings', 'ERR_REG_PASS_TOO_SHORT'))
		);
	}
	
	public function attributeLabels()
	{
		return array('lblUsername'=>Yii::t('lstrings', 'USERNAME'),
				'lblPassword'=>Yii::t('lstrings', 'PASSWORD'));
	}

	/* public function relations()
	{
		return array(
				'author'=>array(self::BELONGS_TO, 'User', 'author_id'),
				'operationHistory'=>array(self::HAS_MANY, 'Operation',
						'tbl_post_category(post_id, category_id)'),
		);
	} */

	public $id;
	public $username;
	public $password;
	
	public function __construct($username = NULL,
			$password = NULL,
			$id = Util::ID_UNDEFINED) {
		$this->username = $username;
		$this->password = $password;
		$this->id = $id;
	}
	
	public function validate() {
		$connection = Yii::app()->db;
		try {
		$rowsAffected = $connection->createCommand()->insert(SqlUtil::USER_TBL, 
				array(SqlUtil::USER_PASSWORD_COL => $this->password,
						SqlUtil::USER_USERNAME_COL => $this->username));
		// bind the 1st column (username) with the $username variable
		#$rowsAffected->bindColumn(1, $username);
		// 		// bind the 2nd column (email) with the $email variable
		// 		$dataReader->bindColumn(2, $password);
		// 		while($dataReader->read()!==false)
			// 		{
			// 		    // $username and $email contain the username and email in the current row
			// 		}
// 		if($rowsAffected === 0)
// 			$this->errorCode = self::ERROR_UNKNOWN_IDENTITY;
// 		// 		else if($users[$this->username]!==$this->password)
// 			// 			$this->errorCode=self::ERROR_PASSWORD_INVALID;
// 		else
			return TRUE;
		//return !$this->errorCode;
		} catch (Exception $ex) {
			if ($ex->getCode() == 23000) {
				return Yii::t('lstrings', 'ERR_REGISTER_EXIST_USR');
			} else
				return Yii::t('lstrings', 'ERR_REGISTER').'<br />'.$ex->getMessage().
				'<br />'.$ex->getCode();
		}
	}
	
	public function getName() {
		return $this->username;
	}
}
	