<?php
/**
 * Contains all the necessary information for a certain file on the disk; It can be used when
 * uploading something from the the user
 * @author andrei
 *
 */
class FileItem extends CActiveRecord
{
	public $id;
	/** @var string The real name of the file on the disk */
	public $diskName;
	/** @var string The name displayed to the user */
	public $name;
	/** @var string The size on the disk */
	public $size;
	/** @var string The type of the file; Used for inheritance to be able to decide type wothout instanceof */
	public $fileType;
	// ... other attributes
	
	public function __construct($fileType = -1, $diskName = '', $name = '', $size = -1//, $id = -1
	) {
		//$this->id = $id;
		$this->name = $name;
		$this->size = $size;
		$this->diskName = $diskName;
		$this->fileType = $fileType;
	}
	
	/**
	 * Deletes a file fromt he database and the disk
	 * @param int $id The id of the file to be deleted
	 * @param string $expPath The path of the experiment which includes this file; It is required to
	 * remove the files on the disk; This is the full path of the experiment, starting from the OS root folder
	 */
	public function deleteFile($id, $expPath) {
		//removes the  disk file
		unlink($expPath.$diskName);
		//removes the DB entry
		$this->deleteByPk($id);
	}
	
	public function relations()
	{
		return array(
				'experiment'=>array(self::HAS_ONE, 'Experiment',
						SqlUtil::EXPERIMENT_FILEITEM_FK)
		);
	}
	
	/**
	 * Save a file in the database with all the necessary data. This method must be implemented by all subclasses to
	 * save they own specific data and to call the parent method
	 * @param int $id The id of the file to be saved
	 */
	public function saveFile($id) {
		//$model = FileItem::model();
		if ($id == -1) {
			$dbI = Yii::app()->db;
			$fileI = $dbI->createCommand()->insert(SqlUtil::FILEITEM_TBL,
					array(SqlUtil::FILEITEM_DISKNAME => $this->diskName,
					SqlUtil::FILEITEM_NAME => $this->name,
					SqlUtil::FILEITEM_SIZE => $this->size,
					SqlUtil::FILEITEM_FILETYPE => $this->fileType));
			$this->id = $dbI->getLastInsertID();
			/* $model->setIsNewRecord(true);
			$model->save(); */
		} else {
			$fileI = Yii::app()->db->createCommand()->update(SqlUtil::FILEITEM_TBL,
					array(//SqlUtil::ID_COL => $id,
					SqlUtil::FILEITEM_DISKNAME => $this->diskName,
					SqlUtil::FILEITEM_NAME => $this->name,
					SqlUtil::FILEITEM_SIZE => $this->size,
					SqlUtil::FILEITEM_FILETYPE => $this->fileType),
					SqlUtil::ID_COL.' = '.$id);
			$this->id = $id;
			/* $model->setId($id);
			$model->setPrimaryKey($id);
			$model->setIsNewRecord(false);
			$model->update(); */
		}
	}
	
	/**
	 * Loads a file using its id; This function must be implemented by all children which have
	 * different fields than their parents since they will a have a separate table; It fills the class values
	 * with the ones extracted from the database
	 * @param int $id The id of the main FileItem table; it is used by its children as foreign key
	 */
	public function loadFile($id) {
		$resultFileR =  Yii::app()->db->createCommand() ->select()
			->from(SqlUtil::FILEITEM_TBL)
			->where(array('and', SqlUtil::ID_COL.'='.$id))
			->queryRow();
		if ($resultFileR == false)
			throw new Exception(Yii::t('lstrings', '10003'), 10003);
		else {
			$this->id = $id;
			$this->diskName = $resultFileR[SqlUtil::FILEITEM_DISKNAME];
			$this->name = $resultFileR[SqlUtil::FILEITEM_NAME];
			$this->size = $resultFileR[SqlUtil::FILEITEM_SIZE];
			$this->fileType = $resultFileR[SqlUtil::FILEITEM_FILETYPE];
		}
	}
	
	/* protected function instantiate($attributes) {
		$class=$attributes['type'];
		$model=new $class(null);
		return $model;
	} */
	
	/* public function beforeSave() {
		if ($this->isNewRecord) {
			$this->fileType = get_class($this);
		}
		return parent::beforeSave();
	} */
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	} 
	
	public function tableName()
	{
		return SqlUtil::FILEITEM_TBL;
	}
	
	public function primaryKey()
	{
		return SqlUtil::ID_COL;
		// For composite primary key, return an array like the following
		// return array('pk1', 'pk2');
	}
	
	public function getId() {
		return $this->id;
	}
	
	public function setId($value) {
		$this->id = $value;
	}
	
	public function getName() {
		return $this->name;
	}
	
	public function setName( $name) {
		$this->name = $name;
	}
	
	public function getDiskName() {
		return $this->diskName;
	}
	
	public function setDiskName( $diskName) {
		$this->diskName = $diskName;
	}
	
	public function getSize() {
		return $this->size;
	}
	
	public function setSize($size) {
		$this->size = $size;
	}
	
	public function getFileType() {
		return $this->fileType;
	}
	
	public function setFileType($size) {
		$this->fileType = $size;
	}
	
	/**
	 * Check if the current object is a virtual file (doesn't have a disk corrspondent)
	 * @return boolean Whether it is virtual or not
	 */
	public function isVirtual() {
		return $this->fileType == FileItemFactory::FILE_TYPE_VIRTUAL;
	}
}