<?php
/**
 * Contains all the necessary information for a certain data file on the disk; It can be used when
 * uploading something from the the user
 * @author andrei
 *
 */
class FileItemData extends FileItem
{
	public $id_fileitem;
	/** @var int number of genes in the file; for now it considers all the lines, but the first one which is the header  */
	public $numGenes;
	/** @var char What is the delimiter between each cell of a row in the file */
	public $delimiter;
	/** @var boolean This file still have lines that contains NA (missing) values  */
	public $hasNA;
	
	public function __construct($fileType = 0, $diskName = NULL, $name = NULL, $size = -1, $numGenes = 0,
			$delimiter = ';', $hasNA = false, $id = 0, $id_fileitem = -1) {
		parent::__construct($fileType, $diskName, $name, $size, $id);
		$this->numGenes = $numGenes;
		$this->delimiter = $delimiter;
		$this->hasNA = $hasNA;
		$this->id_fileitem = $id_fileitem;
		
	}
	
	public function deleteFile($id, $expPath) {
		//removes the DB entry
		$this->deleteByPk($id);
		parent::deleteFile($id, $expPath);
	}
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	/* public function relations()
	{
		return array(
				'fileitem'=>array(self::HAS_ONE, 'FileItem',
						SqlUtil::FILEITEMDATA_FILEITEM_FK)
		);
	} */
	
	public function primaryKey()
	{
		return SqlUtil::FILEITEMDATA_FILEITEM_FK;
		// For composite primary key, return an array like the following
		// return array('pk1', 'pk2');
	}
	
	/* function defaultScope() {
		return array(
				'condition'=>"fileType='FileItemData'",
		);
	}
	 */
	
	public function saveFile($id) {
		parent::saveFile($id);
		/* $model = new FileItemData($this->fileType, $this->diskName, $this->name, $this->size, $this->numGenes,
			$this->delimiter, $this->hasNA, $this->id, $this->id_fileitem);  */
		/* $model = FileItemData::model('FileItemData');
		$model->setIdFileItem($id);
		//$model->setPrimaryKey($id);
		$model->setIsNewRecord(true);
		$model->save(); */
		$fileI = Yii::app()->db->createCommand()->insert(SqlUtil::FILEITEMDATA_TBL,
				array(SqlUtil::FILEITEMDATA_FILEITEM_FK => $this->id,
						SqlUtil::FILEITEMDATA_NUMGENES => $this->numGenes,
						SqlUtil::FILEITEMDATA_DELIMITER => $this->delimiter,
						SqlUtil::FILEITEMDATA_HASNA => $this->hasNA));
	}	
	
	public function loadFile($id) {
		try {
			parent::loadFile($id);
			$resultFileR = Yii::app()->db->createCommand() ->select()
				->from(SqlUtil::FILEITEMDATA_TBL)
				->where(array('and', SqlUtil::FILEITEMDATA_FILEITEM_FK.'='.$id))
				->queryRow();
			if ($resultFileR === false)
				throw new Exception(Yii::t('lstrings', '10003'), 10003);
			else {
				$this->numGenes = $resultFileR[SqlUtil::FILEITEMDATA_NUMGENES];
				$this->delimiter = $resultFileR[SqlUtil::FILEITEMDATA_DELIMITER];
				$this->hasNA = $resultFileR[SqlUtil::FILEITEMDATA_HASNA];
				$this->id_fileitem = $id;
			}
		} catch (Exception $e) {
			throw $e;
		}
	}
	
	public function tableName()
	{
		return SqlUtil::FILEITEMDATA_TBL;
	} 
	
	/* public function save() {
		parent::save();
		$this->id_fileitem = $this->id;
		$this->save();
	} */
	
	public function setIdFileItem($value) {
		$this->id_fileitem = $value;
	}
	
	public function getNumGenes() {
		return $this->numGenes;
	}
	
	public function setNumGenes($value) {
		$this->numGenes = $value;
	}
	
	/**
	 * Get the delimiter for a CSV file
	 * @param boolean $escapeDelim Determines if the returned value should be escaped or not; It is necessary
	 * to use escaped values when they are used as command line arguments for external programs (like C and R)
	 * but not when they are used internally in PHP
	 */
	public function getDelimiter($escapeDelim = true) {
		if ($escapeDelim && ($this->delimiter === ';' ||
				$this->delimiter === ','))
			return '\\'.$this->delimiter;
		else 
			return $this->delimiter;
	}
	
	public function setDelimiter($value) {
		$this->delimiter = $value;
	}
	
	public function getHasNA() {
		return $this->hasNA;
	}
	
	public function setHasNA($value) {
		$this->hasNA = $value;
	}
	
	public function hasTRRA() {
		return false;
	}
	
	public function hasTimePoint() {
		return false;
	}
	
	/**
	 * 
	 * @return int Number of experiment times available in the file; Nota that if the file has both RA and TR values then it only reports the number of times for one of the types since the other one has the exact same amount
	 */
	public function getNumExpTimes() {
		return 0;
	}
	
	/**
	 * Returns an array consisting of the actual times found in the file's header
	 */
	public function getTimesArray() {}
	
}