<?php
/**
 * Specialized file for storing information related to experiment files which contains RA and/or TR values
 * @author andrei
 *
 */
class FileItemDataTRRA extends FileItemData
{
	const TR_PATTERN = '/^TR{1}[\s, \t]+[0-9]+/';
	const RA_PATTERN = '/^RA{1}[\s, \t]+[0-9]+/'; 
	 /* const TR_PATTERN = '/^TR\s{1}[0-9]+/';
	 const RA_PATTERN = '/^RA\s{1}[0-9]+/';  */
	
	/** @var int number of RA columns, each having it's own different time */
	public $numRA;
	/** @var int number of TR columns, each having it's own different time */
	public $numTR;
	/** @var array int Contains the list of times in minutes at which a RA experiment took place */
	public $arrRA;
	/** @var array int Contains the list of times in minutes at which a TR experiment took place */
	public $arrTR;
	
	public $id_fileitemdata;
	
	public function __construct($fileType = 0, $diskName = NULL, $name = NULL, $size = -1, $numGenes = 0, $numTR = 0, $numRA = 0, 
			$delimiter = ';', $hasNA = false, $arrTR = NULL, $arrRA = NULL, $id = 0) {
		parent::__construct($fileType, $diskName, $name, $size, $numGenes, $delimiter, $hasNA, $id);
		$this->numRA = $numRA;
		$this->numTR = $numTR;
		$this->arrRA = $arrRA;
		$this->arrTR = $arrTR;
	}
	
	public function deleteFile($id, $expPath) {
		//remove the arrays from db
		$dbI = Yii::app()->db->createCommand()->delete(SqlUtil::FILEITEMDATAARR_TBL,
				array(SqlUtil::FILEITEMDATAARR_FILEITEMDATA_FK => $this->id));
		//removes the DB entry
		$this->deleteByPk($id);
		parent::deleteFile($id, $expPath);
	}
	
	
	public function loadFile($id) {
		try {
			parent::loadFile($id);
			$resultFileR = Yii::app()->db->createCommand() ->select()
			->from(SqlUtil::FILEITEMDATATRRA_TBL)
			->where(array('and', SqlUtil::FILEITEMDATATRRA_FILEITEMDATA_FK.'='.$id))
			->queryRow();
			if ($resultFileR == false)
				throw new Exception(Yii::t('lstrings', '10003'), 10003);
			else {
				$this->numRA = $resultFileR[SqlUtil::FILEITEMDATATRRA_NUMRA_COL];
				$this->numTR = $resultFileR[SqlUtil::FILEITEMDATATRRA_NUMTR_COL];
				//load array from memory
				$resultArr = Yii::app()->db->createCommand() ->select()
					->from(SqlUtil::FILEITEMDATAARRLINK_TBL.' u')
					->join(SqlUtil::FILEITEMDATAARR_TBL.' p', 
							'u.'.SqlUtil::FILEITEMDATAARRLINK_FILEITEMDATAARR_FK.' = p.'.SqlUtil::ID_COL)
					->where(array('and', SqlUtil::FILEITEMDATAARRLINK_FILEITEMDATA_FK.'='.$id))
					->order(SqlUtil::FILEITEMDATAARR_VALUE.' ASC')
					->queryAll();
				if($resultArr == false)
					throw new Exception(Yii::t('lstrings', '10003'), 10003);
				else {
					$this->arrRA = array();
					$this->arrTR = array();
					foreach ($resultArr as $row) {
						$val = (int)$row[SqlUtil::FILEITEMDATAARR_VALUE];
						$this->arrRA[$val] = $val;
						$this->arrTR[$val] = $val;
					}
				}
			}
		} catch (Exception $e) {
			throw $e;
		}
	}
	
	/* public function relations()
	{
		return array(
				'fileitemdata'=>array(self::HAS_ONE, 'FileItem',
						SqlUtil::FILEITEMDATATRRA_FILEITEMDATA_FK)
		);
	} */
	
	/* function defaultScope() {
		return array(
				'condition'=>"fileType='FileItemDataTRRA'",
		);
	} */
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return SqlUtil::FILEITEMDATATRRA_TBL;
	} 

	public function primaryKey()
	{
		return SqlUtil::FILEITEMDATATRRA_FILEITEMDATA_FK;
		// For composite primary key, return an array like the following
		// return array('pk1', 'pk2');
	}
	
	public function saveFile($id) {
		parent::saveFile($id);
		/* $model = new FileItemDataTRRA($this->fileType, $this->diskName, $this->name, $this->size, 
				$this->numGenes, $this->numTR, $this->numRA, 
			$this->delimiter, $this->hasNA, NULL, NULL, $this->id); */
		/* $model = FileItemDataTRRA::model('FileItemDataTRRA');
		$model->setIdFileItemData($id);
		$model->setIsNewRecord(true);
		$model->save(); */
		$dbI = Yii::app()->db;
		$fileI = $dbI->createCommand()->insert(SqlUtil::FILEITEMDATATRRA_TBL,
				array(SqlUtil::FILEITEMDATATRRA_FILEITEMDATA_FK => $this->id,
						SqlUtil::FILEITEMDATATRRA_NUMRA_COL => $this->numRA,
						SqlUtil::FILEITEMDATATRRA_NUMTR_COL => $this->numTR));
		
		//save the values for times
		//check if we have an one column file
		if ($this->arrTR == NULL)
			$arrayTimes = $this->arrRA;
		else if ($this->arrRA == NULL) 
			$arrayTimes = $this->arrTR;
		else 
			$arrayTimes = $this->arrRA;
		//create a transaction for a greater speed
		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			foreach ($arrayTimes as $key=>$value) {
				$dbI->createCommand()->insert(SqlUtil::FILEITEMDATAARR_TBL,
						array(SqlUtil::FILEITEMDATAARR_VALUE => $value));
				$dbI->createCommand()->insert(SqlUtil::FILEITEMDATAARRLINK_TBL,
						array(SqlUtil::FILEITEMDATAARRLINK_FILEITEMDATA_FK => $this->id,
								SqlUtil::FILEITEMDATAARRLINK_FILEITEMDATAARR_FK => $dbI->getLastInsertID()));
			}
			$transaction->commit();
		}
		catch (Exception $e)
		{
			$transaction->rollBack();
			//Yii::app()->user->setFlash('error', "{$e->getMessage()}");
			$this->refresh();
			throw $e;
		}
	}
	
	public function setIdFileItemData($value) {
		$this->id_fileitemdata = $value;
	}
	
	public function getNumRA() {
		return $this->numRA;
	}
	
	public function setNumRA($value) {
		$this->numRA = $value;
	}
	
	public function getNumTR() {
		return $this->numTR;
	}
	
	public function setNumTR($value) {
		$this->numTR = $value;
	}
	
	public function getArrRA() {
		return $this->arrRA;
	}
	
	public function setArrRA($value) {
		$this->arrRA = $value;
	}
	
	public function getArrTR() {
		return $this->arrTR;
	}
	
	public function setArrTR($value) {
		$this->arrTR = $value;
	}
	
	public function hasTRRA() {
			return true;
	}
	
	public function hasTR() {
		if ($this->numTR > 0) 
			return true;
		else
			return false;
	}
	
	public function hasRA() {
		if ($this->numRA > 0)
			return true;
		else
			return false;
	}
	
	/**
	 * @return number The value of the first time in the file (corresponding to the first column)
	 */
	public function getFirstTime() {
		$arr = array_values($this->arrTR);
		return $arr[0];
	}
	
	public function getNumExpTimes() {
		if (isset($this->arrTR))
			return count($this->arrTR);
		else
			return -1;
	}
	
	public function getTimesArray() {
		if ($this->arrRA != NULL)
			return $this->arrRA;
		else if ($this->arrTR != NULL)
			return $this->arrTR;
		else 
			return NULL;
	}
	
}