<?php
/**
 * Contains all the necessary information for a certain data file on the disk; It can be used when
 * uploading something from the the user
 * @author andrei
 *
 */
class FileItemDataTimePoint extends FileItemData
{
	const TIME_POINT_PATTERN = '/^K\([0-9\.]+\){1}/';
	const TIME_POINT_PATTERN_FIRST_COL = 'K0';
	/** @var int Number of times used for the results of the C programs*/
	public $numTimePoint;
	/** @var array int Contains the list of times in minutes generated by the C programs */
	public $arrTimePoint;
	
	public function __construct($fileType = 0, $diskName = NULL, $name = NULL, $size = -1, $numGenes = 0, 
			$delimiter = ';', $hasNA = false, $numTimePoint = 0, $arrTimePoint = NULL, $id = 0) {
		parent::__construct($fileType, $diskName, $name, $size, $numGenes, $delimiter, $hasNA, $id);
		$this->numTimePoint = $numTimePoint;
		$this->arrTimePoint = $arrTimePoint;
	}
	
	public function deleteFile($id, $expPath) {
		//remove the arrays from db
		$dbI = Yii::app()->db->createCommand()->delete(SqlUtil::FILEITEMDATAARR_TBL,
				array(SqlUtil::FILEITEMDATAARR_FILEITEMDATA_FK => $this->id));
		//removes the DB entry
		//$this->deleteByPk($id);
		parent::deleteFile($id, $expPath);
	}
	
	public function primaryKey()
	{
		return SqlUtil::FILEITEMDATATIMEPOINT_FILEITEMDATA_FK;
		// For composite primary key, return an array like the following
		// return array('pk1', 'pk2');
	}
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return SqlUtil::FILEITEMDATATIMEPOINT_TBL;
	}
	
	public function saveFile($id) {
		parent::saveFile($id);
		$dbI = Yii::app()->db;
		$fileI = $dbI->createCommand()->insert(SqlUtil::FILEITEMDATATIMEPOINT_TBL,
				array(SqlUtil::FILEITEMDATATIMEPOINT_FILEITEMDATA_FK => $this->id,
						SqlUtil::FILEITEMDATATIMEPOINT_NUMTIMEPOINT => $this->numTimePoint));
	
		//save the values for times
		//create a transaction for a greater speed
		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			foreach ($this->arrTimePoint as $key=>$value) {
				$dbI->createCommand()->insert(SqlUtil::FILEITEMDATAARR_TBL,
							array(SqlUtil::FILEITEMDATAARR_VALUE => $value));
				$dbI->createCommand()->insert(SqlUtil::FILEITEMDATAARRLINK_TBL,
							array(SqlUtil::FILEITEMDATAARRLINK_FILEITEMDATA_FK => $this->id,
									SqlUtil::FILEITEMDATAARRLINK_FILEITEMDATAARR_FK => $dbI->getLastInsertID()));
			}
			$transaction->commit();
		}
		catch (Exception $e)
		{
			$transaction->rollBack();
			//Yii::app()->user->setFlash('error', "{$e->getMessage()}");
			$this->refresh();
			throw $e;
		}
	}
	
	public function loadFile($id) {
		try {
			parent::loadFile($id);
			$resultFileR = Yii::app()->db->createCommand() ->select()
				->from(SqlUtil::FILEITEMDATATIMEPOINT_TBL)
				->where(array('and', SqlUtil::FILEITEMDATATIMEPOINT_FILEITEMDATA_FK.'='.$id))
				->queryRow();
			if ($resultFileR == false)
				throw new Exception(Yii::t('lstrings', '10003'), 10003);
			else {
				$this->numTimePoint = $resultFileR[SqlUtil::FILEITEMDATATIMEPOINT_NUMTIMEPOINT];
				//load array from DB
				$resultArr = Yii::app()->db->createCommand() ->select()
					->from(SqlUtil::FILEITEMDATAARRLINK_TBL.' u')
					->join(SqlUtil::FILEITEMDATAARR_TBL.' p', 
							'u.'.SqlUtil::FILEITEMDATAARRLINK_FILEITEMDATAARR_FK.' = p.'.SqlUtil::ID_COL)
					->where(array('and', SqlUtil::FILEITEMDATAARRLINK_FILEITEMDATA_FK.'='.$id))
					->order(SqlUtil::FILEITEMDATAARR_VALUE.' ASC')
					->queryAll();
				if($resultArr == false)
					throw new Exception(Yii::t('lstrings', '10003'), 10003);
				else {
					$this->arrTimePoint = array();
					foreach ($resultArr as $row) {
						$val = (int)$row[SqlUtil::FILEITEMDATAARR_VALUE];
						$this->arrTimePoint[$val] = $val;
					}
				}
			}
		} catch (Exception $e) {
			throw $e;
		}
	}
	
	
	public function getNumTimePoint() {
		return $this->numTimePoint;
	}
	
	public function setNumTimePoint($value) {
		$this->numTimePoint = $value;
	}
	
	public function getArrTimePoint() {
		return $this->arrTimePoint;
	}
	
	public function setArrTimePoint($value) {
		$this->arrTimePoint = $value;
	}
	
	public function hasTimePoint() {
		return true;
	}
	
	public function getNumExpTimes() {
		if (isset($this->arrTimePoint))
			return count($this->arrTimePoint);
		else 
			return -1;
	}
	
	public function getTimesArray() {
		return $this->arrTimePoint;
	}
	
}