<?php
/**
 * The input for a certain operation; You can add external resources 
 * to run in the whole process
 * @author andrei
 *
 */
class Input extends CActiveRecord
{	
	
	/** @var FileItem the input file for the experiment*/
	public $file;
	public $id;

	public function __construct(FileItem $file = NULL, $id = Util::ID_UNDEFINED) {
		$this->id = $id;
		$this->file = $file;
	}
	
	/**
	 * Deletes an input from the database
	 * @param int $id The id of the input to be deleted
	 * @param string $expPath The path of the experiment which includes this file; It is required to
	 * remove the files on the disk; This is the full path of the experiment, starting from the OS root folder
	 */
	public function deleteInput($id, $expPath) {
		//check if file is related to other results or inputs, if not delete it
		if (SqlUtil::isFileUniRef($this->file->getId()))
			$this->file-> deleteFile($this->file->getId(), $expPath);
		//delete input from database
		$this->deleteByPk($id);
	}
	
	public function saveInput($id, $idOperation) {
		$arrayCols = array(SqlUtil::INPUT_OPERATION_FK => $idOperation,
				SqlUtil::INPUT_FILEITEM_FK => $this->file->getId());
		//$model = FileItem::model();
		if ($id == -1) {
			$dbI = Yii::app()->db;
			$fileI = $dbI->createCommand()->insert(SqlUtil::INPUT_TBL,
					$arrayCols);
			$this->id = $dbI->getLastInsertID();
			/* $model->setIsNewRecord(true);
			 $model->save(); */
		} else {
			$fileI = Yii::app()->db->createCommand()->update(SqlUtil::INPUT_TBL,
					$arrayCols,	SqlUtil::ID_COL.' = '.$id);
			$this->id = $id;
		}
	}
	
	/**
	 * Loads the input associated with the operation represented by the id; The db values are set
	 * in the current objects fields
	 * @param int $idOperation The operation which contains the result
	 * @throws Exception Error when trying to load the data from db
	 */
	public function loadInput($idOperation) {
		$resultFileR =  Yii::app()->db->createCommand() ->select()
		->from(SqlUtil::INPUT_TBL)
		->where(array('and', SqlUtil::INPUT_OPERATION_FK.'='.$idOperation))
		->queryRow();
		if ($resultFileR == false)
			throw new Exception(Yii::t('lstrings', '10004'), 10004);
		else {
			$this->id = $idOperation;
			try {
				$f = FileItemFactory::createFileDb((int)$resultFileR[SqlUtil::INPUT_FILEITEM_FK]);
				$this->file = $f;
			} catch(Exception $e) {
				throw $e;
			}
		}
	}
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return SqlUtil::INPUT_TBL;
	}
	
	public function primaryKey()
	{
		return SqlUtil::ID_COL;
		// For composite primary key, return an array like the following
		// return array('pk1', 'pk2');
	}
	
	public function getFile() {
		return $this->file;
	}
	
	public function setFile(FileItem $value) {
		$this->file = $value;
	}
	
	public function setId($value) {
		$this->id =  $value;
	}
	
	public function getId() {
		return $this->id;
	}
	
	
}
?>