<?php
/**
 * The generic results for a run
 * @author andrei
 *
 */
class Result extends CActiveRecord
{
	
	/** the id of the result */
	public $id;
	/** @var FileItem the name of the file on the disk*/
	public $file; 
	
	public $message;
	
	public function __construct(FileItem $file = NULL, $id = Util::ID_UNDEFINED, $message = NULL) {
		$this->id = $id;
		$this->file = $file;
		$this->message = $message;		
	}
	
	/**
	 * Deletes a result from the database
	 * @param int $id The id of the result to be deleted
	 * @param string $expPath The path of the experiment which includes this file; It is required to
	 * remove the files on the disk; This is the full path of the experiment, starting from the OS root folder
	 */
	public function deleteResult($id, $expPath) {
		try {
			//check if file is related to other results or inputs, if not delete it
			if (SqlUtil::isFileUniRef($this->file->getId()))
				$this->file-> deleteFile($this->file->getId(), $expPath);
			//delete result from database
			$this->deleteByPk($id);
		} catch (Exception $e) {
			throw $e;
		}
	}
	
	public function saveResult($id, $idOperation) {
		$arrayCols = array(SqlUtil::RESULT_OPERATION_FK => $idOperation,
				SqlUtil::RESULT_FILEITEM_FK => $this->file->getId(),
				SqlUtil::RESULT_MESSAGE => $this->message);
		//$model = FileItem::model();
		if ($id == -1) {
			$dbI = Yii::app()->db;
			$fileI = $dbI->createCommand()->insert(SqlUtil::RESULT_TBL,
					$arrayCols);
			$this->id = $dbI->getLastInsertID();
			/* $model->setIsNewRecord(true);
			 $model->save(); */
		} else {
			$fileI = Yii::app()->db->createCommand()->update(SqlUtil::RESULT_TBL,
					$arrayCols,	SqlUtil::ID_COL.' = '.$id);
			$this->id = $id;
		}
	}
	
	/**
	 * Loads the result associated with the operation represented by the id; The db values are set
	 * in the current objects fields
	 * @param int $idOperation The operation which contains the result
	 * @throws Exception Error when trying to load the data from db
	 */
	public function loadResult($idOperation) {
		$resultFileR =  Yii::app()->db->createCommand() ->select()
		->from(SqlUtil::RESULT_TBL)
		->where(array('and', SqlUtil::RESULT_OPERATION_FK.'='.$idOperation))
		->queryRow();
		if ($resultFileR == false)
			throw new Exception(Yii::t('lstrings', '10002'), 10002);
		else {
			$this->id = $idOperation;
			$this->message = $resultFileR[SqlUtil::RESULT_MESSAGE];			
			try {
				$f = FileItemFactory::createFileDb((int)$resultFileR[SqlUtil::RESULT_FILEITEM_FK]);
				$this->file = $f;
			} catch(Exception $e) {
				throw $e;
			}			
		}
	}
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return SqlUtil::RESULT_TBL;
	}
	
	public function primaryKey()
	{
		return SqlUtil::ID_COL;
	}
	
	public function setId($value) {
		$this->id =  $value;
	}
	
	public function getId() {
		return $this->id;
	}
	
	public function setMessage($value) {
		$this->message =  $value;
	}
	
	public function getMessage() {
		return $this->message;
	}
	
	public function getFile() {
		return $this->file;
	}
	
	public function setFile(FileItem $value) {
		$this->file = $value;
	}
	
	/**
	 * @return array FileItem Returns an array containing all files for a certain type of Operation
	 * this method is required because some operations may have more than one file
	 * and they may be required; The children of this class may overwrite it and add new files to the final result
	 */
	public function getAllFiles() {
		return array($this->file);
	}
}