<?php
/**
 * Base class for all analyzation algorithms implementing all common methods
 * @author andrei
 *
 */
class AnalyseForm extends Operation
{
	/** @const char The delimiter used to bind together the elements of an array sent as a parameter to the C program */
	const ARRAY_DELIMITER = '_';
	
	public function __construct($operationType = Util::ID_UNDEFINED, $algorithmType = Util::ID_UNDEFINED, 
			$date = 0, Input $input = NULL, Result $result = NULL,
			$experimentTimes = NULL, $description = NULL, $title = NULL, $id = -1) {
		parent::__construct($operationType, $algorithmType, $date,  $input, $result,
				$experimentTimes, $description, $title, $id);
	}

	public function loadOperation($rowOperation) {
		try {
				parent::loadOperation($rowOperation);
				
			}  catch (Exception $e) {
				throw $e;
			}
	}
	
	public function saveOperation($id) {
		try {
			parent::saveOperation($id);
			$fileI = Yii::app()->db->createCommand()->insert(SqlUtil::ANALYSEFORM_TBL,
					array(SqlUtil::ANALYSEFORM_OPERATION_FK => $this->id));
		}  catch (Exception $e) {
			throw $e;
		}
		
	}
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return SqlUtil::ANALYSEFORM_TBL;
	}
	
	public function primaryKey()
	{
		return SqlUtil::ANALYSEFORM_OPERATION_FK;
	}
	
	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return parent::attributeLabels();
	}
	
	
	/**
	 * Determine the id of the form for each algorithm type
	 * @return string the id of the form to be used in the view and controller
	 */
	public function getFormId(){
		return 'analyseSetForm';
	}
	
	public function getOpListLink() {
		return 'exp/experiment/page/view/analyse_list';
	}
	
	public function getOpName() {
		return Yii::t('lstrings', 'ANALYSE_MENU');
	}
	
	/**
	 * @return boolean Whether to display or not a link pointing to the result file to be downloaded by the user
	 */
	public function displayResultFileDown(){
		return false;
	}
	
	public function isOpAnalyse() {
		return true;
	}
}