<?php
/**
 * Base class for all analyzation algorithms implementing all common methods
 * @author andrei
 *
 */
class AnalyseKResForm extends AnalyseForm
{
	/** @var string Number of genes in the file, determined directly from file */
	private $numGenesDef;
	/** @var string What is the array of the times selected from the list of the available times */
	public $addedTimes;
	/** @var string Number of genes as set by the user */
	public $numGenes;
	
	public function __construct($operationType = Util::ID_UNDEFINED, $algorithmType = Util::ID_UNDEFINED, 
			$date = 0, Input $input = NULL, Result $result = NULL,
			$experimentTimes = NULL, $description = NULL, $title = NULL, $id = Util::ID_UNDEFINED) {
		parent::__construct($operationType, $algorithmType, $date,  $input, $result,
				$experimentTimes, $description, $title, $id);
		if (Yii::app()->session['currentExperiment'] != NULL && Yii::app()->session['currentExperiment']->getCurrentOpFile() != NULL) 
			$this->numGenesDef = Yii::app()->session['currentExperiment']->getCurrentOpFile()->getNumGenes(); 
		$this->numGenes = $this->numGenesDef;
	}
	
	public function loadOperation($rowOperation) {
			$dbI = Yii::app()->db;
		$dataR = $dbI->createCommand() ->select()
		->from(SqlUtil::ANALYSEKRESFORM_TBL)
		->where(array('and', SqlUtil::ANALYSEKRESFORM_ANALYSEFORM_FK.'='.$rowOperation[SqlUtil::ID_COL]))
		->queryRow();
		if($dataR == false)
			throw new Exception(Yii::t('lstrings', '10001'), 10001);
		else {
			$this->numGenes = $dataR[SqlUtil::ANALYSEKRESFORM_NUMGENES];
			//load the list of times
			$dataR = $dbI->createCommand() ->select()
				->from(SqlUtil::ANALYSEKRESFORMADDEDTIMES_TBL)
				->order(SqlUtil::ANALYSEKRESFORMADDEDTIMES_VALUE.' ASC')
				->where(array('and', SqlUtil::ANALYSEKRESFORMADDEDTIMES_ANALYSEKRESFORM_FK.'='.$rowOperation[SqlUtil::ID_COL]))
				->queryAll();
			if($dataR == false)
				throw new Exception(Yii::t('lstrings', '10001'), 10001);
			else {
				$this->addedTimes = array();
				$index = 0;
				foreach ($dataR as $row) {
					$this->addedTimes[$index++] = $row[SqlUtil::ANALYSEKRESFORMADDEDTIMES_VALUE];
				}
			}
			try {
				parent::loadOperation($rowOperation);
			}  catch (Exception $e) {
				throw $e;
			}
		}
	}
	
	public function saveOperation($id) {
		parent::saveOperation($id);
		$dbI = Yii::app()->db;
		$fileI = $dbI->createCommand()->insert(SqlUtil::ANALYSEKRESFORM_TBL,
				array(SqlUtil::ANALYSEKRESFORM_ANALYSEFORM_FK => $this->id,
						SqlUtil::ANALYSEKRESFORM_NUMGENES => $this->numGenes));
		//insert added times in the database
		$transaction = $dbI->beginTransaction();
		try
		{
			foreach ($this->addedTimes as $value) {
				$dbI->createCommand()->insert(SqlUtil::ANALYSEKRESFORMADDEDTIMES_TBL,
						array(SqlUtil::ANALYSEKRESFORMADDEDTIMES_ANALYSEKRESFORM_FK => $this->id,
								SqlUtil::ANALYSEKRESFORMADDEDTIMES_VALUE => $value));
			}
			$transaction->commit();
		}
		catch (Exception $e)
		{
			$transaction->rollBack();
			//Yii::app()->user->setFlash('error', "{$e->getMessage()}");
			$this->refresh();
			throw $e;
		}
	}
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return SqlUtil::ANALYSEKRESFORM_TBL;
	}
	
	public function primaryKey()
	{
		return SqlUtil::ANALYSEKRESFORM_ANALYSEFORM_FK;
	}
	
	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array_merge(parent::attributeLabels(), array(
				'lblAddedTimes'=>Yii::t('lstrings', 'C_ADDED_TIMES'),
				'lblAvailTimes'=>Yii::t('lstrings', 'C_AVAILABLE_TIMES'),
				'lblNumGenes'=>Yii::t('lstrings', 'C_NUMBER_GENES'))
		);
	}
	
	public function rules()
	{
		return array_merge(parent::rules(), array(
				array('addedTimes', 'ext.myvalidators.CArrayValidator', 'lMin' => 1),
				//array('addedTimes', 'in', 'range'=> $this->experiment->getCurrentOpFile()->getArrTR()),
				array('numGenes', 'numerical', 'allowEmpty' => false, 'integerOnly' => true, 
						'max' => Yii::app()->session['currentExperiment']->getCurrentOpFile()->getNumGenes(), 
						'min' => 1))
		);
	}
	
	/**
	 * This function is used to execute a C program and send the required and
	 * specific parameters for each type of algorithm 
	 * @param String $arguments
	 */
	protected function executeC($script, $arguments) {
		//save old file and create a new one
		//$diskFName = $this->date.$this->experiment->getCurrentOpFile()->getDiskName();
		$diskFName = $this->date.$this->getAlgoName().'.csv';
		//$tempFName = rand().$newFName;
		$loc = Yii::app()->basePath.
				Yii::app()->session['currentExperiment']->path;
		/* if (file_exists($loc.$newFName)) { */
			/* if (rename($loc.$newFName,
					$loc.$oldFName)) { */
				//set input file
				$this->input->setFile($this->experiment->getCurrentOpFile());
				//replace the result for the last operation if any (it points to the name of the file
				// as uploaded by the user
				
				//run the script
				$ret = shell_exec(Yii::app()->basePath.'/commands/shell/c/'.$script.' '.				
						Yii::app()->basePath.
						$this->experiment->path.' '.
						$this->experiment->getCurrentOpFile()->getDiskName().' '.
						$diskFName.' '.
						AnalyseForm::RESULT_SUCCESS.' '.
						$this->input->getFile()->getDelimiter().' '.
						(count($this->addedTimes)+1).' '.
						implode(AnalyseForm::ARRAY_DELIMITER, array_merge(array($this->experiment->getCurrentOpFile()->getFirstTime()), 
								array_values($this->addedTimes))).' '. 
						$this->numGenes.' '.
						$this->experiment->getCurrentOpFile()->getNumExpTimes().' '.
						$this->getInvColsInd().
						' 2>&1');
				if (strpos($ret, Operation::RESULT_SUCCESS) === false) {//undo everything
					//try to remove if any file was generated
					if (file_exists($loc.$diskFName))
						unlink($loc.$diskFName);
					//set message
					$this->result->setMessage($ret);						
				} else {					
					//get the result file and analyze it
					$resultFile = FileItemFactory::createFile(FileItemFactory::FILE_TYPE_DATA_TIME_POINT,
							$loc, $diskFName, $this->experiment->getCurrentOpFile()->getName());
						
					$this->result->setFile($resultFile);
					$this->result->setMessage(Yii::t('lstrings', 'SUCCESSFULLY_ANALYSE'));
					//$this->result->setMessage($ret);
					//set the result file as the current operation one
					$this->experiment->setCurrentOpFile($resultFile);
					//if user has logged in save the result in the DB
					if (!Yii::app()->user->isGuest) {
						$this->saveOperation(Util::ID_UNDEFINED);
					}
				}
			//}
		/* } else {
			$this->result->setMessage(Yii::t('lstrings', 'ERR_C_FILE_LOST'));
		} */
		//echo $ret;
	}
	
	/**
	 * @return string A string resembling the array with the indeces of the columns which will be discarded from the computation; The indeces are the same as in the original array meaning that they will start from 0 so the 7th column will have an index equal to 6
	 */
	protected function getInvColsInd() {
		// It only works for files with both TR and RA and since the number of cols for both TR and RA are the same, any of the 2 can be used 
		$timesArray = $this->experiment->getCurrentOpFile()->getArrTR();
		$result = '';
		$lenArray = count($timesArray);
		/* for ($index =0 ; $index<$lenArray; $index++) 
			if (!in_array($timesArray[$index], $this->addedTimes))
				$result = $result.$index.AnalyseForm::ARRAY_DELIMITER; */
		$index = 0;
		foreach  ($timesArray as $myKey => $value) {
			if (!in_array($value, $this->addedTimes))
				$result = $result.$index.AnalyseForm::ARRAY_DELIMITER;
			$index++;
		}
		return $result;
	}
	
	public function getNumTimes()
	{
		return $this->numTimes;
	}
	/**
	 * set number of times added by the user in the UI; It doesn't need a value since it can use the already
	 * set value for the number of times (which must be an array)
	 * @var int/NULL value number of times; can be either NULL if counting is preferred or a value
	 * 		which has a higher priority and will be set as the value for the attribute
	 * @return boolean if the value could be set
	 */
	public function setNumTimes($value = NULL)
	{
		if (isset($this->times)) {
			$this->numTimes = count($this->times);
			return true;
		}
		else if ($value !== NULL) {
			$this->numTimes = $value;
			return true;
		} else 
			return false;
	}
	
	/**
	 * Use it when you need the name of the current algorithm for the analyzation operation
	 * @return string the name of the algorithm, translated in the current language if appropriate
	 */
	public function getAlgoName() {
		switch ($this->algorithmType) {
			case Operation::ALGO_GENARRAY:
				return Yii::t('lstrings', 'GENARRAY_SMENU');
			case Operation::ALGO_STABILOGEN:
				return Yii::t('lstrings', 'STABILOGEN_SMENU');
		}
	}
	
	/**
	 * Determine the id of the form for each algorithm type
	 * @return string the id of the form to be used in the view and controller
	 */
	public function getFormId(){
		return 'analyseSetForm';
	}
	
	public function getOpListLink() {
		return 'exp/experiment/page/view/analyse_list';
	}
	
	public function getOpName() {
		return Yii::t('lstrings', 'ANALYSE_MENU');
	}
	
	public function getTimeList() {
		//remove first column (it will be added automatically)
		return array_slice($this->experiment->getCurrentOpFile()->getArrTR(), 1, count($this->experiment->getCurrentOpFile()->getArrTR())-1,
				true);
	}
	
	public function getNumGenes() {
		return $this->numGenes;
	}
	
	public function loadOldValues(Operation $oldObject) {
		parent::loadOldValues($oldObject);
		$this->numGenes = $oldObject->getNumGenes();
	}
}