<?php
/**
 * The shutoff algorithm whihc implements the Spearman coefficient and the slope of the 
 * linear regression. It runs the corresponding R script to determine the results
 * @author andrei
 *
 */

class ShutoffForm extends AnalyseForm {

	
	public function __construct($operationType = ShutoffForm::OP_ANALYSE, 
			$algorithmType = ShutoffForm::ALGO_SHUTOFF,
			$date = 0, Input $input = NULL, Result $result = NULL,
			$title = NULL, $description = NULL, $experimentTimes = Util::ID_UNDEFINED, 
			$id = Util::ID_UNDEFINED) {
		parent::__construct($operationType, $algorithmType, $date,  $input, $result,
				ShutoffForm::EXP_TIMES_TR, $description, $title, $id);
	}
	
	
	public function loadOperation($rowOperation) {
		try {
			parent::loadOperation($rowOperation);
		}  catch (Exception $e) {
			throw $e;
		}
	}
	
	public function saveOperation($id) {
		try
		{
			parent::saveOperation($id);
		}catch (Exception $e)
		{
			throw $e;
		}
	}
	
	
	public function runMethod() {		
		//run the script
		$nameOutput = $this->date.$this->getAlgoName();
		$ret = shell_exec('Rscript '. Yii::app()->basePath.'/commands/shell/r/shutoff.r '.
				Yii::app()->basePath.
				$this->experiment->path.' '.
				$this->experiment->getCurrentOpFile()->getDiskName().' '.
				$nameOutput.' '.
				Operation::RESULT_SUCCESS.' '.
				$this->getExperimentTimes().' '.
				$this->experiment->getCurrentOpFile()->getDelimiter().' '.
				implode(AnalyseForm::ARRAY_DELIMITER, $this->input->getFile()->getTimesArray()).' '.
				' 2>&1');
		//echo $ret;
		//$path = Yii::app()->basePath.$this->experiment->path.$nameOutput.'csv';
		//check if the execution was successfull by examining the output, and the 2 required out files
		#echo $ret;
		if (strpos($ret, Operation::RESULT_SUCCESS) === false) {
			$this->result->setMessage($ret);
		} else {
			$this->input->setFile($this->experiment->getCurrentOpFile());
			$this->result->setMessage(Yii::t('lstrings', 'SUCCESSFULLY_ANALYSE'));
			//get the result file and analyze it
			$resultFile = FileItemFactory::createFile(FileItemFactory::FILE_TYPE_GENERIC,
					Yii::app()->basePath.$this->experiment->path, $nameOutput.'.csv', $this->experiment->getCurrentOpFile()->getName());
			
			$this->result->setFile($resultFile);
			//if user has logged in save the result in the DB
			if (!Yii::app()->user->isGuest) {
				$this->saveOperation(Util::ID_UNDEFINED);
			}
		}
	}
	
	public function getAlgoLink() {
		return '/exp/op/analyse/shutoff';
	}
	
	public function getAlgoName() {
		return Yii::t('lstrings', 'SHUTOFF_SMENU');
	}
	
	public function getRLExpTimesList() {
		return array(ShutoffForm::EXP_TIMES_TR => Yii::t('lstrings', 'USE_TR'),
        						ShutoffForm::EXP_TIMES_RA => Yii::t('lstrings', 'USE_RA'));
	}
	
	public function displayResultFileDown(){
		//always show the download result link 
		return true;
	}
}