<?php

/**
 * The result of a clustering method
 * @author andrei
 *
 */
class ResultCluster extends Result
{
	/** @var FileItemData The result in text format containing the clusters obtained by running the algorithm*/
	public $fileData;
	/** @var FileItem This file contains all the clusters generated by a certain algorithm along with the number of genes in each cluster followed by a list of included genes */
	public $fileCluster;
	
	public function __construct(FileItem $fileCluster = NULL, FileItemData $fileData = NULL, 
			FileItem $file = NULL, $id = Util::ID_UNDEFINED) {
		parent::__construct($file, $id);
		$this->fileData = $fileData;
		$this->fileCluster = $fileCluster;
	}
	
	public function deleteResult($id, $expPath) {
		try {
			//check if file is related to other results or inputs, if not delete it
			if (SqlUtil::isFileUniRef($this->fileData->getId()))
				$this->fileData-> deleteFile($this->fileData->getId(), $expPath);
			//check if file is related to other results or inputs, if not delete it
			if (SqlUtil::isFileUniRef($this->fileCluster->getId()))
				$this->fileCluster-> deleteFile($this->fileCluster->getId(), $expPath);
			//remove the arrays from db
			$dbI = Yii::app()->db->createCommand()->delete(SqlUtil::RESULTCLUSTER_TBL,
					array(SqlUtil::RESULTCLUSTER_RESULT_FK => $id));
			parent::deleteResult($id, $expPath);
		} catch (Exception $e) {
			throw $e;
		}
	}
	
	public function saveResult($id, $idOperation) {
		parent::saveResult($id, $idOperation);
		$this->fileData != NULL ?
			$idFileData = $this->fileData->getId() : $idFileData = NULL;
		$this->fileCluster != NULL ?
			$idFileCluster = $this->fileCluster->getId() : $idFileCluster = NULL;
		$fileI = Yii::app()->db->createCommand()->insert(SqlUtil::RESULTCLUSTER_TBL,
				array(SqlUtil::RESULTCLUSTER_RESULT_FK => $idOperation,
							SqlUtil::RESULTCLUSTER_FILEITEM_FILEDATA_FK =>  $idFileData,
						SqlUtil::RESULTCLUSTER_FILEITEM_FILECLUSTER_FK => $idFileCluster));
	}
	
	public function loadResult($idOperation) {
		parent::loadResult($idOperation);
		//try and load the files
		$resultR =  Yii::app()->db->createCommand() ->select()
			->from(SqlUtil::RESULTCLUSTER_TBL)
			->where(array('and', SqlUtil::RESULTCLUSTER_RESULT_FK.'='.$this->id))
			->queryRow();
		if ($resultR == false)
			throw new Exception(Yii::t('lstrings', '10002'), 10002);
		else {
			try {
				//load the 2 files if theirs ids are not NULL
				if (($idFD = $resultR[SqlUtil::RESULTCLUSTER_FILEITEM_FILEDATA_FK]) != NULL) {
					$f = FileItemFactory::createFileDb((int)$idFD);
					$this->fileData = $f;
				}
				
				if (($idFC = $resultR[SqlUtil::RESULTCLUSTER_FILEITEM_FILECLUSTER_FK]) != NULL) {
					$f = FileItemFactory::createFileDb((int)$idFC);
					$this->fileCluster = $f;
				}
			} catch(Exception $e) {
				throw $e;
			}
		}
	}
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return SqlUtil::RESULTCLUSTER_TBL;
	}
	
	public function getFileData() {
		return $this->fileData;
	}
	
	public function setFileData(FileItemData $value) {
		$this->fileData = $value;
	}
	
	public function getFileCluster() {
		return $this->fileCluster;
	}
	
	public function setFileCluster(FileItem $value) {
		$this->fileCluster = $value;
	}
	
	public function getAllFiles() {
		if (isset($this->fileData) && isset($this->fileCluster))
			return  array_merge(parent::getAllFiles(), array($this->fileData, $this->fileCluster));
		else
			return parent::getAllFiles();
	}

}