<?php
/**
 * Implementation for the sota algorithm
 * @author andrei
 *
 */
class SotaForm extends ClusterForm
{
	
	public $maxCycles = 4;
	public $maxEpochs = 1000;
	public $distMethod;
	public $wcell = 0.01;
	public $pcell = 0.005;
	public $scell = 0.001;
	public $delta = 1e-04;
	public $neighbLevel = 0;
	public $maxDiversity = 0.9;
	public $unrestGrowth;
	
	
	public function __construct($operationType = UpgmaForm::OP_CLUSTER, 
			$algorithmType = UpgmaForm::ALGO_SOTA, $date = 0, Input $input = NULL, Result $result = NULL,
			$title = NULL, $description = NULL, $experimentTimes = Operation::EXP_TIMES_TR_RA, $id = Util::ID_UNDEFINED) {
		parent::__construct($operationType, $algorithmType, $date,  $input, $result,
				$experimentTimes, $description, $title, $id);
	}
	
	public function primaryKey()
	{
		return SqlUtil::SOTAFORM_CLUSTERFORM_FK;
	}
	
	public function deleteOperation($id) {
		try {
			$this->deleteByPk($id);
			parent::deleteOperation($id);
		} catch (Exception $e) {
			throw $e;
		}
	}
	
	public function loadOperation($rowOperation) {
		$dataR = Yii::app()->db->createCommand() ->select()
			->from(SqlUtil::SOTAFORM_TBL)
			->where(array('and', SqlUtil::SOTAFORM_CLUSTERFORM_FK.'='.$rowOperation[SqlUtil::ID_COL]))
			->queryRow();
		if($dataR == false)
			throw new Exception(Yii::t('lstrings', '10001'), 10001);
		else {
			$this->maxCycles = $dataR[SqlUtil::SOTAFORM_MAXCYCLES];
			$this->maxEpochs = $dataR[SqlUtil::SOTAFORM_MAXEPOCHS];
			$this->wcell = $dataR[SqlUtil::SOTAFORM_WCELL];
			$this->pcell = $dataR[SqlUtil::SOTAFORM_PCELL];	
			$this->scell = $dataR[SqlUtil::SOTAFORM_SCELL];
			$this->delta = $dataR[SqlUtil::SOTAFORM_DELTA];
			$this->neighbLevel = $dataR[SqlUtil::SOTAFORM_NEIGHBLEVEL];
			$this->maxDiversity = $dataR[SqlUtil::SOTAFORM_MAXDIVERSITY];	
			$this->unrestGrowth = $dataR[SqlUtil::SOTAFORM_UNRESTGROWTH];			
			try {
				$this->result = new ResultCluster();
				$this->result->loadResult($rowOperation[SqlUtil::ID_COL]);
				parent::loadOperation($rowOperation);
			}  catch (Exception $e) {
				throw $e;
			}
		}
	}
	
	public function saveOperation($id) {
		parent::saveOperation($id);
		$fileI = Yii::app()->db->createCommand()->insert(SqlUtil::SOTAFORM_TBL,
				array(SqlUtil::SOTAFORM_CLUSTERFORM_FK => $this->id,
						SqlUtil::SOTAFORM_MAXCYCLES => $this->maxCycles,
						SqlUtil::SOTAFORM_MAXEPOCHS => $this->maxEpochs,
						SqlUtil::SOTAFORM_DISTMETHOD => $this->distMethod,
						SqlUtil::SOTAFORM_WCELL => $this->wcell,
						SqlUtil::SOTAFORM_PCELL => $this->pcell,
						SqlUtil::SOTAFORM_SCELL => $this->scell,
						SqlUtil::SOTAFORM_DELTA => $this->delta,
						SqlUtil::SOTAFORM_MAXDIVERSITY => $this->maxDiversity,
						SqlUtil::SOTAFORM_UNRESTGROWTH => $this->unrestGrowth));
	}
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return SqlUtil::SOTAFORM_TBL;
	}
	
	
	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array_merge(parent::attributeLabels(), array(
				'lblMaxCycles'=>Yii::t('lstrings', 'SOTA_MAX_CYCLES'),
				'lblMaxEpochs'=>Yii::t('lstrings', 'SOTA_MAX_EPOCHS'),
				'lblDistMethod'=>Yii::t('lstrings', 'SOTA_DISTANCE'),
				'lblWcell'=>Yii::t('lstrings', 'SOTA_WCELL'),
				'lblPcell'=>Yii::t('lstrings', 'SOTA_PCELL'),
				'lblScell'=>Yii::t('lstrings', 'SOTA_SCELL'),
				'lblDelta'=>Yii::t('lstrings', 'SOTA_DELTA'),
				'lblNeighbLevel'=>Yii::t('lstrings', 'SOTA_NEIGHB_LEVEL'),
				'lblMaxDiversity'=>Yii::t('lstrings', 'SOTA_MAX_DIVERSITY'),
				'lblUnrestGrowth'=>Yii::t('lstrings', 'SOTA_UNREST_GROWTH'),
		));
	}
	
	public function rules()
	{
		return array_merge(parent::rules(), array(array('maxCycles, maxEpochs, distMethod, wcell, 
						pcell, scell, delta, neighbLevel, maxDiversity,
						unrestGrowth', 'required'),
				array('maxCycles, maxEpochs, wcell, 
						pcell, scell, delta, neighbLevel, maxDiversity', 'numerical'),
				array('distMethod', 'in', 'range'=> array('euclidean', 'correlation'),
				/* array('unrestGrowth', 'boolean', 'falseValue' => 'false',
						'trueValue' => 'true') */
						),
		));
	}
	
	public function runMethod() {
		parent::executeR('sota.r', $this->maxCycles.' '.$this->maxEpochs.' '.$this->distMethod
				.' '.$this->wcell.' '.$this->pcell.' '.$this->scell.' '.$this->delta
				.' '.$this->neighbLevel.' '.$this->maxDiversity.' '.$this->unrestGrowth);
	}
	
	public function getAlgoLink() {
		return 'exp/op/cluster/sota';
	}
	
	public function getAlgoName() {
		return Yii::t('lstrings', 'SOTA_SMENU');
	}
	
	public function loadOldValues(Operation $oldObject) {
		parent::loadOldValues($oldObject);
		$this->maxCycles = $oldObject->getMaxCycles();
		$this->maxEpochs = $oldObject->getMaxEpochs();
		$this->distMethod = $oldObject->getDistMethod();
		$this->wcell = $oldObject->getWcell();
		$this->pcell = $oldObject->getPcell();
		$this->scell = $oldObject->getScell();
		$this->delta = $oldObject->getDelta();
		$this->neighbLevel = $oldObject->getNeighbLevel();
		$this->maxDiversity = $oldObject->getMaxDiversity();
		$this->unrestGrowth = $oldObject->getUnrestGrowth();
	}
	
	public function getUnrestGrowth() {
		return $this->unrestGrowth;
	}
	
	public function getMaxDiversity() {
		return $this->maxDiversity;
	}
	
	public function getNeighbLevel() {
		return $this->neighbLevel;
	}
	
	public function getDelta() {
		return $this->delta;
	}
	
	public function getScell() {
		return $this->scell;
	}
	
	public function getPcell() {
		return $this->pcell;
	}
	
	public function getWcell() {
		return $this->wcell;
	}
	
	public function getDistMethod() {
		return $this->distMethod;
	}
	
	public function getMaxEpochs() {
		return $this->maxEpochs;
	}
	
	public function getMaxCycles() {
		return $this->maxCycles;
	}
}