<?php

/**
 * Class which keeps all the settings and logic of the UPGMA algorithm and which stands behind the View
 * to perform all the needed tasks (like vlaidation, labeling etc)
 * @author andrei
 *
 */
class UpgmaForm extends ClusterForm
{	
	const CUT_DENDRO_HEIGHT = 2001;
	const CUT_DENDRO_NUM_CLUSTERS = 2002;
	const CUT_DENDRO_NONE = 2003;
	
	 /* public static $AGG_ALGORITHMS = array('average', 'ward', 'single',
						'complete', 'mcquitty', 'median', 'centroid'); 
	public static $DIST_ALGORITHMS = array('euclidean', 'maximum', 'manhattan',
			'canberra', 'binary', 'pearson', 'abspearson', 'correlation',
			'abscorrelation', 'spearman', 'kendall');  */
	/** @var string method for aggregation */
	public $aggMethod;
	/** @var string method for distance */
	public $distMethod; 
	/** @var int The type of cut for a dendrogram representation; Values: CUT_DENDRO_HEIGHT, CUT_DENDRO_NUM_CLUSTERS, CUT_DENDRO_NONE; Defaults to CUT_DENDRO_NONE*/
	public $dendroCutType = UpgmaForm::CUT_DENDRO_NONE;
	/** @var mixed (int/double) It can be either the number of clusters to be left after the cut (int) or the height at which the dendrogram will be cut. The meaning of the value is set by the the type of the cut. Defaults to 0 */
	public $dendroCutVal = 0;
	
	
	public function __construct($operationType = UpgmaForm::OP_CLUSTER, 
			$algorithmType = UpgmaForm::ALGO_UPGMA, $date = 0, Input $input = NULL, Result $result = NULL,
    		$title = NULL, $description = NULL, $experimentTimes = Operation::EXP_TIMES_TR_RA, 
			$id = Util::ID_UNDEFINED, $aggMethod = NULL,
			$distMethod = NULL) {
		parent::__construct($operationType, $algorithmType, $date,  $input, $result,
    		$experimentTimes, $description, $title, $id); 
		$this->aggMethod = $aggMethod;
		$this->distMethod = $distMethod;
	}
	
	public function primaryKey()
	{
		return SqlUtil::UPGMAFORM_CLUSTERFORM_FK;
	}
	
	public function deleteOperation($id) {
		try {
			$this->deleteByPk($id);
			parent::deleteOperation($id);
		} catch (Exception $e) {
			throw $e;
		}
	}
	
	public function loadOperation($rowOperation) {
		$dataR = Yii::app()->db->createCommand() ->select()
		->from(SqlUtil::UPGMAFORM_TBL)
		->where(array('and', SqlUtil::UPGMAFORM_CLUSTERFORM_FK.'='.$rowOperation[SqlUtil::ID_COL]))
		->queryRow();
		if($dataR == false)
			throw new Exception(Yii::t('lstrings', '10001'), 10001);
		else {
			$this->aggMethod = $dataR[SqlUtil::UPGMAFORM_AGGMETHOD];
			$this->dendroCutType = $dataR[SqlUtil::UPGMAFORM_DENDROCUTTYPE];
			$this->dendroCutVal = $dataR[SqlUtil::UPGMAFORM_DENDROCUTVAL];
			$this->distMethod = $dataR[SqlUtil::UPGMAFORM_DISTHMETHOD];
			try {
				$this->result = new ResultCluster();
				$this->result->loadResult($rowOperation[SqlUtil::ID_COL]);
				parent::loadOperation($rowOperation);
			}  catch (Exception $e) {
				throw $e;
			}
		}
	}
	
	public function saveOperation($id) {
		parent::saveOperation($id);
		$fileI = Yii::app()->db->createCommand()->insert(SqlUtil::UPGMAFORM_TBL,
				array(SqlUtil::UPGMAFORM_CLUSTERFORM_FK => $this->id,
						SqlUtil::UPGMAFORM_AGGMETHOD => $this->aggMethod,
						SqlUtil::UPGMAFORM_DISTHMETHOD => $this->distMethod,
						SqlUtil::UPGMAFORM_DENDROCUTTYPE => $this->dendroCutType,
						SqlUtil::UPGMAFORM_DENDROCUTVAL => $this->dendroCutVal));
	}
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return SqlUtil::UPGMAFORM_TBL;
	}
	
	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array_merge(parent::attributeLabels(), array(
				'aggMethodLabel'=>Yii::t('lstrings', 'UPGMA_AGGLOMERATION_METHOD'),
				'distMethodLabel'=>Yii::t('lstrings', 'UPGMA_DIST_MATRIX_METHOD'),
				'lblDendroCutType'=>Yii::t('lstrings', 'UPGMA_DENDRO_CUT_TYPE'),
				'lblDendroCutVal'=>Yii::t('lstrings', 'UPGMA_DENDRO_CUT_VAL'),
		));
	}
	
	 public function rules()
	{
		return array_merge(parent::rules(), array(array('aggMethod, distMethod', 'required'),
				array('aggMethod', 'in', 'range'=> array('average', 'ward', 'single',
						'complete', 'mcquitty', 'median', 'centroid')),
				array('distMethod', 'in', 'range'=> array('euclidean', 'maximum', 'manhattan',
			'canberra', 'binary', 'pearson', 'abspearson', 'correlation',
			'abscorrelation', 'spearman', 'kendall')),
				array('dendroCutType', 'in', 'range'=> array(UpgmaForm::CUT_DENDRO_NONE,
						UpgmaForm::CUT_DENDRO_NUM_CLUSTERS,
						UpgmaForm::CUT_DENDRO_HEIGHT)),
				array('dendroCutVal', 'numerical', 'min' => 0),
		));
	} 
	
	public function runMethod() {
		//the value of dendroCutType must be checked otherwise if the radio button list is disabled, the web application will send an empty value even if one button is selected
		if (!isset($this->dendroCutType) || $this->dendroCutType == '')
			$this->dendroCutType = UpgmaForm::CUT_DENDRO_NONE;
		parent::executeR('upgma.r', $this->dendroCutType.' '.
				$this->dendroCutVal.' '.
				$this->aggMethod.' '.$this->distMethod);
	}
	
// 	public function hasResultFileCluster() {
// 		if ($this->dendroCutType == UpgmaForm::CUT_DENDRO_NONE)
// 			return false;
// 		else 
// 			return true;
// 	}
	
// 	public function hasResultFileData() {
// 		if ($this->dendroCutType == UpgmaForm::CUT_DENDRO_NONE)
// 			return false;
// 		else 
// 			return true;
// 	}
	
	public function getAlgoLink() {
		return 'exp/op/cluster/upgma';
	}
	
	public function getAlgoName() {
		return Yii::t('lstrings', 'UPGMA_SMENU');
	}
	
	public function hasResultFileCluster() {
		if ($this->result->getMessage() === Operation::RESULT_SUCCESS)
		return $this->voutType == UpgmaForm::VOUT_TYPE_DENDROGRAM && 
			$this->dendroCutType != UpgmaForm::CUT_DENDRO_NONE;
		else 
			return false;
	}
	
	public function hasResultFileData() {
		if ($this->result->getMessage() === Operation::RESULT_SUCCESS)
		return $this->voutType == UpgmaForm::VOUT_TYPE_DENDROGRAM && 
			$this->dendroCutType != UpgmaForm::CUT_DENDRO_NONE;
		else 
			return false;
	}
	
	/**
	 * @return boolean Whether the radio buttons list with the selection for the type of dendrogram cut is disabled when the page loads; It must be disabled if the output type is not a dendrogram
	 */
	public function isDendroCutTypeDisabled() {
		return $this->voutType != UpgmaForm::VOUT_TYPE_DENDROGRAM;
	}
	
	/**
	 * @return boolean Whether the control used to enter the cut values is disabled or not; It must be enabeld only for dendrograms and when No cut is unselected
	 */
	public function isDendroCutValDisabled() {
		return $this->dendroCutType == UpgmaForm::CUT_DENDRO_NONE || 
		 $this->voutType != UpgmaForm::VOUT_TYPE_DENDROGRAM;
	}
	
	public function loadOldValues(Operation $oldObject) {
		parent::loadOldValues($oldObject);
		$this->distMethod = $oldObject->getDistMethod();
		$this->aggMethod = $oldObject->getAggMethod();
		$this->dendroCutType = $oldObject->getDendroCutType();
		$this->dendroCutVal = $oldObject->getDendroCutVal();
	}
	
	public function getDendroCutVal() {
		return $this->dendroCutVal;
	}
	
	public function getDendroCutType() {
		return $this->dendroCutType;
	}
	
	public function getAggMethod() {
		return $this->aggMethod;
	}
	
	public function getDistMethod() {
		return $this->distMethod;
	}
	
}