<?php

/**
 * Base class for the filtering operations; Any class which implements a filter mechanism
 * must inherit from this
 * @author andrei
 *
 */
class FilterForm extends Operation {
	
	
	
	public function __construct($operationType = FilterForm::OP_FILTER, $algorithmType = FilterForm::ALGO_FILTER_NA, 
			$date = 0, Input $input = NULL, Result $result = NULL,
			$experimentTimes = NULL, $description = NULL, $title = NULL, $id = Util::ID_UNDEFINED) {
		parent::__construct($operationType, $algorithmType, $date,  $input, $result,
				$experimentTimes, $description, $title, $id);
	}
	
	public function deleteOperation($id) {
		parent::deleteOperation($id);
	}
	
	public function saveOperation($id) {
		parent::saveOperation($id);
	}
	
	public function loadOperation($rowOperation) {
		try {
			parent::loadOperation($rowOperation);
		}  catch (Exception $e) {
			throw $e;
		}
	}
	
	public function rules()
	{
		return parent::rules();
	}
	
	public function attributeLabels()
	{
		return parent::attributeLabels();
	}
	
	public function getOpListLink() {
		return 'exp/experiment/page/view/filter_list';
	}
	
	public function getOpName() {
		return Yii::t('lstrings', 'FILTER_MENU');
	}
	
	public function loadOldValues(Operation $newObject) {
		parent::loadOldValues($newObject);
	}
	
}