<?php

/**
 * Method that eliminates all genes that have more than a certain percentage of unknown values
 * from the input file
 * @author andrei
 *
 */
class FilterNAForm extends FilterForm {
	
	/** @var int specifies how many NA values a certain gene can have; Its values 
	 * are included in the inteval [0, 100]; It can be specified for either TR, RA or TR+RA **/
	public $perAllowedNA = 10;
	
	public function __construct($operationType = FilterForm::OP_FILTER, 
			$algorithmType = FilterForm::ALGO_FILTER_NA, $date = 0, 
			Input $input = NULL, Result $result = NULL,
			$title = NULL, $description = NULL, $experimentTimes = Operation::EXP_TIMES_TR_RA, $id = Util::ID_UNDEFINED) {
		parent::__construct($operationType, $algorithmType, $date,  $input, $result,
				$experimentTimes, $description, $title, $id);
	}
	
	public function primaryKey()
	{
		return SqlUtil::FILTERNAFORM_OPERATION_FK;
	}
	
	public function deleteOperation($id) {
		try {
			$this->deleteByPk($id);		
			parent::deleteOperation($id);
		} catch (Exception $e) {
			throw $e;
		}
	}
	
	public function saveOperation($id) {
		parent::saveOperation($id);
		$fileI = Yii::app()->db->createCommand()->insert(SqlUtil::FILTERNAFORM_TBL,
				array(SqlUtil::FILTERNAFORM_OPERATION_FK => $this->id,
				SqlUtil::FILTERNAFORM_PERALLOWEDNA => $this->perAllowedNA));
	}
	
	public function loadOperation($rowOperation) {
		$dataR = Yii::app()->db->createCommand() ->select()
			->from(SqlUtil::FILTERNAFORM_TBL)
			->where(array('and', SqlUtil::FILTERNAFORM_OPERATION_FK.'='.$rowOperation[SqlUtil::ID_COL]))
			->queryRow();
		if($dataR == false)
			throw new Exception(Yii::t('lstrings', '10001'), 10001);
		else {
			$this->perAllowedNA = $dataR[SqlUtil::FILTERNAFORM_PERALLOWEDNA];
			try {
				parent::loadOperation($rowOperation);
			}  catch (Exception $e) {
				throw $e;
			}
		}
	}
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public function tableName()
	{
		return SqlUtil::FILTERNAFORM_TBL;
	}
	
	public function attributeLabels()
	{
		return array_merge(parent::attributeLabels(), array(
				'lblPerAllowedNA'=>Yii::t('lstrings', 'FILTER_NA_PER_ALLOWED_NA')));
	}
	
	public function rules()
	{
		return array_merge(parent::rules(), array(
				array('perAllowedNA', 'numerical', 'integerOnly'=>true,
						'allowEmpty' => false, 'min' => 0, 'max' => 100)));
	}
	
	public function runMethod() {
		//the CSV must be opened and then line by line must be checked
		//to see if the number of missing values for a gene is over the desired
		//percentage
		ini_set('auto_detect_line_endings',TRUE);//detect the end of line delimiter
		$lines = 0;
		$fullPath = Yii::app()->basePath.
				$this->experiment->path;
		$delim = $this->experiment->getCurrentOpFile()->getDelimiter(false);
		$fName = $this->experiment->getCurrentOpFile()->getName();
		$newDName = $this->date.get_class($this).'.csv';
		if (($fin = fopen($fullPath.
				$this->experiment->getCurrentOpFile()->getDiskName(), "r")) !== FALSE &&
				($fout = fopen($fullPath.
				$newDName, "w")) !== FALSE) {
			//try and read the header and save it in the new file
			$record = fgetcsv($fin, 0, $delim);
			fputs($fout, implode($delim, $record)."\n");
			//fputcsv($fout, $record, $delim);
			$numMissingAllowed = $this->perAllowedNA / 100.0 * count($record);
			/* //get the number of columns
			 $columns = count($record); */
			//count the number of lines in the file; maybe there is a faster  method
			while (($record = fgetcsv($fin, 0, $delim)) !== FALSE) {
				$countEmpty = 0;
				$lenRecord = count($record);
				foreach ($record as $row) 
					if (strlen($row) === 0)
						$countEmpty++;
				if ($countEmpty <= $numMissingAllowed)
					fputs($fout, implode($delim, $record)."\n");
			}
			fclose($fin);
			fclose($fout);
			//rename the input file as an old version
			#rename($fullPath.$oldFName, $fullPath.$this->date.$oldFName);
			//rename the output file with the name given by the user
			#rename($fullPath.$newFName, $fullPath.$oldFName);
			//save the result and input
			$this->input->setFile($this->experiment->getCurrentOpFile());
			$foutputFile = FileItemFactory::createFile($this->experiment->getCurrentOpFile()->getFileType(),
					$fullPath, 
					$newDName,					
					$fName);
			$this->result->setFile($foutputFile);
			//set the result for the last operation in queue
			#$exp->setFNameLastOpQueue($this->date.$oldFName);
			//add in the operation queue
			$this->experiment->addOperationHistory($this);
			//set current op file
			$this->experiment->setCurrentOpFile($foutputFile);
			$this->result->setMessage(Yii::t('lstrings', 'SUCCESSFULLY_FILTER'));
			//if user has logged in save the result in the DB
			if (!Yii::app()->user->isGuest) {
				$this->saveOperation(Util::ID_UNDEFINED);
			}
			
		} else {
			$this->result->setMessage(Yii::t('lstrings', 'ERR_OPENING_FILE'));
		}
		
	}
	
	public function getAlgoLink() {
		return 'exp/op/filter/filterna';
	}
	
	public function getAlgoName() {
		return Yii::t('lstrings', 'FILTER_NA_SMENU');
	}
	
	public function showFilterNAReminder() {
		return false;
	}
	
	public function loadOldValues(Operation $oldObject) {
		parent::loadOldValues($oldObject);
		$this->perAllowedNA = $oldObject->getPerAllowedNA();
	}
	
	public function getPerAllowedNA() {
		return $this->perAllowedNA;
	}
}