<?php $this->pageTitle=Yii::app()->name.' - '.$model->getAlgoName(); 
$this->breadcrumbs=array(
		$model->getOpName() => array($model->getOpListLink()),
		$model->getAlgoName()
);
?>

<?php $this->renderPartial('/exp/op/file/file_operations');?>
<script> 
$.noConflict();
jQuery(document).ready(function(){
	$('.positive-integer').numeric({ decimal: false, negative: false }, null);
    $('#btnAddTimes').click(function () {
    	moveSelection('#availTimes', '#addedTimes');
    	sortList('#addedTimes');
    });

    $('#btnRemTimes').click(function () {
    	moveSelection('#addedTimes', '#availTimes');
    	sortList('#availTimes');
    });

    $('#btnAddAllTimes').click(function () {
        /*$("#availTimes").each(function(){
            $("#availTimes option").attr("selected","true"); 
    		moveSelection('#availTimes', '#addedTimes');
        });*/
        moveAll('#availTimes', '#addedTimes');
    	sortList('#addedTimes');
    });

    $('#btnRemAllTimes').click(function () {
    	 moveAll('#addedTimes', '#availTimes');
     	sortList('#availTimes');
    });

    $('#analyseSetForm').submit(function(e) {
        $("#addedTimes").each(function(){
            $("#addedTimes option").attr('selected','true'); 
         });
    }) ;

    /**
    * Sorts all the elements of the list when one or more new elements are added or removed
    **/
    function sortList(elementId) {
    	$(elementId).html($("option", $(elementId)).sort(function(a, b) { 
    	    var arel = parseInt($(a).attr('value'), 10);
    	    var brel = parseInt($(b).attr('value'), 10);
    	    return arel == brel ? 0 : arel < brel ? -1 : 1 
    	}));
    }

    function moveSelection(initialList, newList) {
        if ($(initialList+'  option:selected').val() != null) {
	        //add in the new list
	    	$(newList).append('<option value="' + $(initialList+'  option:selected').val() + '">' + 
					$(initialList+' option:selected').val() + '</option>');
			//delete from the old one
	    	$(initialList + ' option:selected').remove();
        }
    }

    function moveAll(initialList, newList) {
    	$(newList).append($(initialList).children());
        $(initialList + ' option:selected').remove();
    }
});
</script>

<div style="float:right; width: 100%">
<div class="form">
<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'analyseSetForm',
	'enableClientValidation'=>true,
	'clientOptions'=>array(
		'validateOnSubmit'=>true,
	),
)); ?>
 
    <?php echo $form->errorSummary($model); ?>
    
    <?php $this->renderPartial('/exp/op/operation_common_form', array('model'=>$model,
 			'form' => $form));?>
 			
 			
 	<div class="row">		
	 	<div style='float:left; margin-left: 7%; width: 30%'>
	 		<?php echo $form->labelEx($model, 'lblAddedTimes', 
        		array('style'=>'display: inline')).Util::generateHelp('102'); ?>
	 		<br/>
	        <?php echo $form->listBox($model, 'addedTimes', 
	        				$data = array(),
	        				array('id' => 'addedTimes',
	        						'multiple' => 'true',
									'style' => 'width: 200px')) ?><br/>	        
	        <?php echo CHtml::button(Yii::t('lstrings', 'REM_ALL_TIME'), 
	        		array('id' => 'btnRemAllTimes')); ?>
									
	    </div> 
		<div style='float:left; width: 30%'>							
	        <?php echo CHtml::button(Yii::t('lstrings', 'ADD_SEL_TIME'), 
	        		array('id' => 'btnAddTimes')); ?><br/>
	        <?php echo CHtml::button(Yii::t('lstrings', 'REM_SEL_TIME'), 
	        		array('id' => 'btnRemTimes'));  ?><br/>
	    </div> 
	    
	    <div style='float:left; margin-right: 2%; width: 30%'>
	 		<?php echo $form->labelEx($model, 'lblAvailTimes', 
        		array('style'=>'display: inline')).Util::generateHelp('103'); ?>
	 		<br/>
	        <?php echo CHtml::listBox('availTimes', null,
	        				$data = $model->getTimeList(),
	        				array('id' => 'availTimes',
	        						'multiple' => 'true',
									'style' => 'width: 200px')) ?><br/>
	        <?php echo CHtml::button(Yii::t('lstrings', 'ADD_ALL_TIME'), 
	        		array('id' => 'btnAddAllTimes')); ?>
	    </div><br/>
    </div>
 <div style="float:right; width: 100%">	
 <div class="row">
        <?php echo $form->label($model,'lblNumGenes', 
        		array('style'=>'display: inline')).Util::generateHelp('104').$form->textField($model,'numGenes',
        				array('class'=>'positive-integer')) ?>
    </div>
   
    <div class="row submit">
        <?php echo CHtml::submitButton(Yii::t('lstrings', 'START_OPERATION')); ?>
    </div>
 
</div> 
  
<?php $this->endWidget(); ?>
</div><!-- form -->
</div>