<?php $this->pageTitle=Yii::app()->name.' - '.$model->getAlgoName(); 
$this->breadcrumbs=array(
		$model->getOpName() => array($model->getOpListLink()),
		$model->getAlgoName()
);
?>

<script>
$.noConflict();

var labelNumElems = "<?php echo Yii::t('lstrings', 'KMEANS_EXP_TIMES_ADD_COUNT') ?>";

jQuery(document).ready(function(){ 
	$(".positive-integer").numeric({ decimal: false, negative: false }, null);	
	setStateClusters(true, false);
	
	<?php 
	//display only if the file has both TR and RA
	if ($model->isRLExpTimesVisible()) { ?>
	disableClusterDisplay();

	// the type of the visual representation has been changed
	$('#voutType').change(function() {
		disableClusterDisplay();
			
	});

	function disableClusterDisplay() {
		if ($('#voutType').val() == <?php echo $model::VOUT_TYPE_CLUSTER; ?>) {//enable cluster representation feature
			$(".clusterDisplay").attr('disabled', false);
				
		} else {
			$(".clusterDisplay").attr('disabled', true);
			//$("#dendroCutVal").attr('disabled', true);
		}
	}
	<?php }?>	

	<?php if ($model->getInput()->getFile()->hasTRRA()) { ?>
	var numTRElems = <?php  echo $model->getInput()->getFile()->getNumTR();  ?>;
	var numRAElems = <?php  echo $model->getInput()->getFile()->getNumRA();  ?>;
	if (numRAElems > 0) {setNumCentersRemain("RA", 0, numRAElems);}
	if (numTRElems > 0) {setNumCentersRemain("TR", 0, numTRElems);}
	 
    $("#btnAddTimesRA").click(function () {addTimes("RA", numRAElems);});

    $("#btnAddTimesTR").click(function () {addTimes("TR", numTRElems);});

    $("#btnRemTimesRA").click(function () {remTimes("RA", numRAElems);});
    $("#btnRemTimesTR").click(function () {remTimes("TR", numTRElems);});

    $("#kmeansSetForm").submit(function(e) {
        if ($('#chkCenters').is(':checked')) {
        	clearValuesClusters();
        	if (numRAElems > 0) {
		        $("#centersRA").each(function(){
		            $("#centersRA option").attr("selected", "true"); 
		       	});
        	}
	        if (numTRElems > 0) {
		        $("#centersTR").each(function(){
		            $("#centersTR option").attr("selected", "true"); 
		       	});
        	}
        } else if ($('#chkClusters').is(':checked')){
        	clearValuesCenters();
        }
    }) ;

    //trigger centers
    $("#chkCenters").click(function() { // attack a click event 
    	if (numRAElems > 0) {
		    setStateCenters("RA", true, false);
    	}
    	if (numTRElems > 0) {
		    setStateCenters("TR", true, false);
    	}
    		setStateClusters(true, false);
	});
    
    //trigger clusters
    $("#chkClusters").click(function() { // attack a click event 
    	if (numRAElems > 0) {
    		setStateCenters("RA", true, false);
    	}
    	if (numTRElems > 0) {
    		setStateCenters("TR", true, false);
    	}
    		setStateClusters(false, true);
	});

    function clearValuesCenters() {
    	$("#centersTR, #centersRA").find("option").remove().end();
    	$("#txtTimesTR, #txtTimesRA").val(null);
    	setNumCentersRemain("RA", 0, numRAElems);
    	setNumCentersRemain("TR", 0, numTRElems);
    }

    
	<?php } else if ($model->getInput()->getFile()->hasTimePoint()) { ?>

	var numTimePointElems = <?php echo $model->getInput()->getFile()->getNumTimePoint(); ?>;
	setNumCentersRemain("TimePoint", 0, numTimePointElems);	 
    $("#btnAddTimesTimePoint").click(function () {addTimes("TimePoint", numTimePointElems);});
    $("#btnRemTimesTimePoint").click(function () {remTimes("TimePoint", numTimePointElems);});

    $("#kmeansSetForm").submit(function(e) {
        if ($('#chkCenters').is(':checked')) {
        	clearValuesClusters();
        	if (numTimePointElems > 0) {
		        $("#centersTimePoint").each(function(){
		            $("#centersTimePoint option").attr("selected", "true"); 
		       	});
        	}
        } else if ($('#chkClusters').is(':checked')){
        	clearValuesCenters();
        }
    }) ;

    //trigger centers
    $("#chkCenters").click(function() { // attack a click event 
		setStateCenters("TimePoint", false, true);
    	setStateClusters(true, false);
	});
    
    //trigger clusters
    $("#chkClusters").click(function() { // attack a click event 
    	setStateCenters("TimePoint", true, false);
    	setStateClusters(false, true);
	});

    function clearValuesCenters() {
    	$("#centersTimePoint").find("option").remove().end();
    	$("#txtTimesTimePoint").val(null);
    	setNumCentersRemain("TimePoint", 0, numTimePointElems);
    }
	

	<?php }?>
    
	
});

function addTimes(expTime, totalCenters) {
	if ($("#centers"+expTime).children().length < totalCenters) {
		if ($("#txtTimes" + expTime).val() != '')  {
    		$("#centers"+expTime).append('<option value="' + $("#txtTimes"+expTime).val() + '">' + 
    	    	$("#txtTimes"+expTime).val() + '</option>');
    		$("#txtTimes"+expTime).val('');
    		setNumCentersRemain(expTime, $("#centers"+expTime).children().length, totalCenters);
    		$("#txtTimes"+expTime).focus();
		}
    } else {
        alert("<?php echo Yii::t('lstrings', 'ERR_KMEANS_ADD_CENTERS_NUM') ?>");
    }
}

function remTimes(expTime, totalCenters) {
	$("#centers" +expTime+" option:selected").remove();
	setNumCentersRemain(expTime, $("#centers"+expTime).children().length, totalCenters);
	$("#centers" +expTime).focus();
}

function setNumCentersRemain(expTime, now, total) {
	$('#lblNumItemsLeft' + expTime).text(now + 
			labelNumElems
		+ total);
}

function setStateCenters(expTime, disabled, checked) {
	$("#centers" +expTime).attr('disabled', disabled);
	$("#txtTimes" +expTime).attr('disabled', disabled);
	$("#btnAddTimes" +expTime).attr('disabled', disabled);
	$("#btnRemTimes" +expTime).attr('disabled', disabled);
	$("#chkCenters").attr('checked', checked);
}

function setStateClusters(disabled, checked) {
	$("#clusters").attr('disabled', disabled);
	$("#numRandSets").attr('disabled', disabled);
	$("#chkClusters").attr('checked', checked);
}

function clearValuesClusters() {
	$("#clusters").val(null);
	$("#numRandSets").val(null);
}

</script>
<div style="float:right; width: 100%">
<div class="form">
<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'kmeansSetForm',
	'enableClientValidation'=>true,
	'clientOptions'=>array(
		'validateOnSubmit'=>true,
	),
)); ?>
 
    <?php echo $form->errorSummary($model); ?>
 
 	<?php $this->renderPartial('/exp/op/operation_common_form', array('model'=>$model,
 			'form' => $form));?>
 			
 	<?php $this->renderPartial('/exp/op/cluster/cluster_common', array('model'=>$model,
 			'form' => $form));?>
 			
 	<div class="row">
        <?php 
        if ($model->isRLExpTimesVisible())
        	echo $form->label($model,'lstClusterDisplay', 
        		array('style'=>'display: inline')).Util::generateHelp('135').
        		$form->radioButtonList($model, 'clusterDisplay',
        				$model->getClusterDisplayArr(),
        				array('labelOptions'=>array('style'=>'display:inline'),
        						'separator'=>'&nbsp;&nbsp;',
        						'class' => 'clusterDisplay')); 
        ?>
	</div>
 
 	<div class="row">
 	
		<?php echo CHtml::radioButton('chkCenters', TRUE,
				array('value' => '0')).
			$form->labelEx($model, 'lstCenters',
					array('style'=>'display: inline')).Util::generateHelp('113'); ?>
		<div style='float:right; width: 100%;'>
		<?php if ($model->isSetExpTimesTRVisible()) {?>
			<div style='float:left; margin-left: 5%'>
		 		<?php echo CHtml::label(Yii::t('lstrings', 'KMEANS_ADD_TR'), 'lblCentersTR',
					array('style'=>'display: inline')).Util::generateHelp('114'); ?>
		 		<br/>
		        <?php echo $form->listBox($model, 'centersTR', 
		        				$data = array(),
		        				array('id' => 'centersTR',
		        						'multiple' => 'true',
										'style' => 'width: 250px')) ?>
		        <br/>
		        <?php echo CHtml::label('', false,
		        		array('id' => 'lblNumItemsLeftTR', 'style'=>'display: inline')).
		        		Util::generateHelp('115'); ?>
		        <br/>
		        <?php echo CHtml::textField('txtTimesTR', '',
		        		array('id' => 'txtTimesTR',
		        				'class'=>'positive-integer',
								'style' => 'width: 80px')); ?>
		        <?php echo CHtml::button(Yii::t('lstrings', 'ADD_CENTER'), 
		        		array('id' => 'btnAddTimesTR')); ?>
		        <?php echo CHtml::button(Yii::t('lstrings', 'REM_SEL_CENTER'), 
		        		array('id' => 'btnRemTimesTR'));  ?>
	        </div>        
        <?php }?>
        
        <?php if ($model->isSetExpTimesRAVisible()) {?>
	        <div style='float:right;margin-right: 1%'>
		 		<?php echo CHtml::label(Yii::t('lstrings', 'KMEANS_ADD_RA'), 'lblCentersRA',
					array('style'=>'display: inline')).Util::generateHelp('113'); ?>
		 		<br/>
		        <?php echo $form->listBox($model, 'centersRA', 
		        				$data = array(),
		        				array('id' => 'centersRA',
		        						'multiple' => 'true',
										'style' => 'width: 250px')) ?>
		        <br/>	
		        <?php echo CHtml::label('', false,
		        		array('id' => 'lblNumItemsLeftRA', 'style'=>'display: inline')).
		        		Util::generateHelp('115'); ?>
		        <br/>					
		        <?php echo CHtml::textField('txtTimesRA', '',
		        		array('id' => 'txtTimesRA',
		        				'class'=>'positive-integer',
								'style' => 'width: 80px')); ?>
		        <?php echo CHtml::button(Yii::t('lstrings', 'ADD_CENTER'), 
		        		array('id' => 'btnAddTimesRA')); ?>
		        <?php echo CHtml::button(Yii::t('lstrings', 'REM_SEL_CENTER'), 
		        		array('id' => 'btnRemTimesRA'));  ?>
	        </div>
        <?php }?>
        
        <?php if ($model->isSetExpTimePointVisible()) {?>
	        <div style='float:left; margin-left: 5%'>
		 		<?php echo CHtml::label(Yii::t('lstrings', 'KMEANS_ADD_TIME_POINT'), 'lblCentersTimePoint',
					array('style'=>'display: inline')).Util::generateHelp('113'); ?>
		 		<br/>
		        <?php echo $form->listBox($model, 'centersTimePoint', 
		        				$data = array(),
		        				array('id' => 'centersTimePoint',
		        						'multiple' => 'true',
										'style' => 'width: 250px')) ?>
		        <br/>	
		        <?php echo CHtml::label('', false,
		        		array('id' => 'lblNumItemsLeftTimePoint', 'style'=>'display: inline')).
		        		Util::generateHelp('115'); ?>
		        <br/>					
		        <?php echo CHtml::textField('txtTimesTimePoint', '',
		        		array('id' => 'txtTimesTimePoint',
		        				'class'=>'positive-integer',
								'style' => 'width: 80px')); ?>
		        <?php echo CHtml::button(Yii::t('lstrings', 'ADD_CENTER'), 
		        		array('id' => 'btnAddTimesTimePoint')); ?>
		        <?php echo CHtml::button(Yii::t('lstrings', 'REM_SEL_CENTER'), 
		        		array('id' => 'btnRemTimesTimePoint'));  ?>
	        </div>
        <?php }?>
        
        </div>
    </div>
    
    <div class="row">
		<?php echo  CHtml::radioButton('chkClusters', FALSE,
				array('name' => 'chkClusters',
						'value' => '1')).$form->labelEx($model, 'lstClusters',
				array('style'=>'display: inline')).Util::generateHelp('116'); ?>
		<br />
		<div style='margin-left: 5%'>
	        <?php echo $form->label($model,'lblClusters', 
	        		array('style'=>'display: inline')).Util::generateHelp('117')
	        			.$form->textField($model,'clusters',
        				array('id' => 'clusters',
        				'class'=>'positive-integer',
        				'value'=> $model->getNumGenes())) ?>
	        		<br />
	        <?php echo $form->label($model,'numRandSets', 
	        		array('style'=>'display: inline')).Util::generateHelp('118').$form->textField($model,'numRandSets',
        				array('id' => 'numRandSets',
        				'class'=>'positive-integer')) ?>
        </div>
	</div>
    
    <div class="row">
        <?php echo $form->label($model,'maxNumIterations', 
        		array('style'=>'display: inline')).Util::generateHelp('119').$form->textField($model,'maxNumIterations',
        				array('id' => 'maxNumIterations',
        				'class'=>'positive-integer')) ?>
    </div>
    
 
     <div class="row">
        <?php 
        echo $form->label($model,'distMethod', array('style'=>'display: inline')).Util::generateHelp('120').
        		$form->dropDownList($model, 'distMethod', 
        		array('euclidean' => Yii::t('lstrings', 'DIST_METH_EUCLIDEAN'), 
        		'maximum' => Yii::t('lstrings', 'DIST_METH_MAXIMUM'), 
        		'manhattan' => Yii::t('lstrings', 'DIST_METH_MANHATTAN'), 
        		'canberra' => Yii::t('lstrings', 'DIST_METH_CANBERRA'), 
        		'binary' => Yii::t('lstrings', 'DIST_METH_BINARY'), 
        		'pearson' => Yii::t('lstrings', 'DIST_METH_PEARSON'), 
        		'abspearson' => Yii::t('lstrings', 'DIST_METH_ABSPEARSON'), 
        		'correlation' => Yii::t('lstrings', 'DIST_METH_CORRELATION'), 
        		'abscorrelation' => Yii::t('lstrings', 'DIST_METH_ABSCORRELATION'), 
        		'spearman' => Yii::t('lstrings', 'DIST_METH_SPEARMAN'), 
        		'kendall' => Yii::t('lstrings', 'DIST_METH_KENDALL'))); ?>
    </div>
 
 
    <div class="row submit">
        <?php echo CHtml::submitButton(Yii::t('lstrings', 'START_OPERATION')); ?>
    </div>
 
<?php $this->endWidget(); ?>
</div><!-- form -->
</div>