<?php $this->pageTitle=Yii::app()->name.' - '.$model->getAlgoName(); 
$this->breadcrumbs=array(
		$model->getOpName() => array($model->getOpListLink()),
		$model->getAlgoName()
);
?>

<script>
$.noConflict();

jQuery(document).ready(function(){ 
	$(".positive-decimal").numeric({ decimal: ".", negative: false }, null);

	// the type of the visual representation has been changed
	$('#voutType').change(function() {
		if ($('#voutType').val() == <?php echo $model::VOUT_TYPE_DENDROGRAM; ?>) {//enable cutting feature
			$(".dendroCutType").attr('disabled', false);
			$(".dendroCutType").each(function(){
	            if (!$(this).is(':checked') && 
	    	            $(this).val() == <?php echo $model::CUT_DENDRO_NONE; ?>)
	            	$("#dendroCutVal").attr('disabled', false);
	       	});			
		} else {
			$(".dendroCutType").attr('disabled', true);
			$("#dendroCutVal").attr('disabled', true);
		}
			
	});

	$("#upgmaSetForm").submit(function(e) {
        if ($('#dendroCutVal').is(':disabled')) {
        	$('#dendroCutVal').val(0);
        }
    }) ;
	
});
/**
 * Respond to a click event and take action according to the selected option. In this moment this function disables the value used for cutting field in case of None selected and enables it otherwise
 * @param value int The value of the newly selected option
 */
function typeDendroCutSel(value) {
	if (value == <?php echo $model::CUT_DENDRO_NONE; ?>) { //disable the input
		$("#dendroCutVal").attr('disabled', true);
	} else { 
		$("#dendroCutVal").attr('disabled', false);
	}
}

</script>

<div style="float:right; width: 100%">
<div class="form">
<?php $form=$this->beginWidget('CActiveForm', array(
	'id'=>'upgmaSetForm',
	'enableClientValidation'=>true,
	'clientOptions'=>array(
		'validateOnSubmit'=>true,
	),
)); ?>
 
    <?php echo $form->errorSummary($model); ?>
 
 	<?php $this->renderPartial('/exp/op/operation_common_form', array('model'=>$model,
 			'form' => $form));?>
 		<?php $this->renderPartial('/exp/op/cluster/cluster_common', array('model'=>$model,
 			'form' => $form));?>
 		
 	<div class="row">
        <?php 
        	echo $form->label($model,'lblDendroCutType', 
        		array('style'=>'display: inline',
        				'disabled' => 'true')).Util::generateHelp('133').
        		$form->radioButtonList($model, 'dendroCutType',
        				array($model::CUT_DENDRO_NONE => Yii::t('lstrings', 'UPGMA_DENDRO_CUT_TYPE_NO_CUT'),
        						$model::CUT_DENDRO_NUM_CLUSTERS => Yii::t('lstrings', 'UPGMA_DENDRO_CUT_TYPE_CLUST'),
        						$model::CUT_DENDRO_HEIGHT => Yii::t('lstrings', 'UPGMA_DENDRO_CUT_TYPE_HEIGHT')),
        				array('labelOptions'=>array('style'=>'display:inline'),
        						'separator'=>'&nbsp;&nbsp;',
        						'disabled' => $model->isDendroCutTypeDisabled(),
        						'class' => 'dendroCutType',
        						'onchange' => 'typeDendroCutSel(this.value);')); 
        ?>
	</div>
 			
 	<div class="row">
         <?php echo $form->label($model,'lblDendroCutVal', 
        		array('style'=>'display: inline')).Util::generateHelp('131').
        		$form->textField($model, 'dendroCutVal', array(
        				'class'=>'positive-decimal',
        				'disabled' => $model->isDendroCutValDisabled(),
        				'id' => 'dendroCutVal')); 
         ?>
    </div>		
 	
    <div class="row">
        <?php
        echo $form->label($model,'aggMethodLabel', array('style'=>'display: inline')).
        	Util::generateHelp('111').$form->dropDownList($model, 'aggMethod', 
        		array('average' => Yii::t('lstrings', 'DIST_METH_AVERAGE'), 
        		'ward' => Yii::t('lstrings', 'DIST_METH_WARD'), 
        		'single' => Yii::t('lstrings', 'DIST_METH_SINGLE'), 
        		'complete' => Yii::t('lstrings', 'DIST_METH_COMPLETE'), 
        		'mcquitty' => Yii::t('lstrings', 'DIST_METH_MCQUITTY'), 
        		'median' => Yii::t('lstrings', 'DIST_METH_MEDIAN'), 
        		'centroid' => Yii::t('lstrings', 'DIST_METH_CENTROID'))); ?>
    </div>
 
     <div class="row">
        <?php 
        echo $form->label($model,'distMethodLabel', array('style'=>'display: inline')).
        		Util::generateHelp('112').$form->dropDownList($model, 'distMethod', 
        		array('euclidean' => Yii::t('lstrings', 'DIST_METH_EUCLIDEAN'), 
        		'maximum' => Yii::t('lstrings', 'DIST_METH_MAXIMUM'), 
        		'manhattan' => Yii::t('lstrings', 'DIST_METH_MANHATTAN'), 
        		'canberra' => Yii::t('lstrings', 'DIST_METH_CANBERRA'), 
        		'binary' => Yii::t('lstrings', 'DIST_METH_BINARY'), 
        		'pearson' => Yii::t('lstrings', 'DIST_METH_PEARSON'), 
        		'abspearson' => Yii::t('lstrings', 'DIST_METH_ABSPEARSON'), 
        		'correlation' => Yii::t('lstrings', 'DIST_METH_CORRELATION'), 
        		'abscorrelation' => Yii::t('lstrings', 'DIST_METH_ABSCORRELATION'), 
        		'spearman' => Yii::t('lstrings', 'DIST_METH_SPEARMAN'), 
        		'kendall' => Yii::t('lstrings', 'DIST_METH_KENDALL'))); ?>
    </div>
 
 
    <div class="row submit">
        <?php echo CHtml::submitButton(Yii::t('lstrings', 'START_OPERATION')); ?>
    </div>
 
<?php $this->endWidget(); ?>
</div></div><!-- form -->